/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.stereotype.Component;

@Component
public class MeetGroupExpireTimerPushSceneService
extends AbstractTimerPushSceneService {
    private final IMeetGroupService meetGroupService;

    public MeetGroupExpireTimerPushSceneService(IPushTaskService pushTaskService, Fetcher fetcher, IMeetGroupService meetGroupService) {
        super(pushTaskService, fetcher);
        this.meetGroupService = meetGroupService;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        String taskSceneCustomConfig = pushTask.getTaskSceneCustomConfig();
        int hours = NumberUtils.toInt((String)taskSceneCustomConfig);
        if (hours <= 0) {
            return null;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(MeetGroup::getGroupStatus, (Object)Constants.MeetGroupConst.GroupStatus.WAIT_ACCEPT.value());
        lambdaQueryWrapper.apply("DATE_SUB(invite_expire_time, INTERVAL " + hours + " HOUR) <= NOW()", new Object[0]);
        List meetGroupList = this.meetGroupService.list((Wrapper)lambdaQueryWrapper);
        return meetGroupList.stream().map(new Function<MeetGroup, PushTarget>(){

            @Override
            public PushTarget apply(MeetGroup meetGroup) {
                return new PushTarget().setUserId(meetGroup.getAcceptUserId()).addExtend("meetGroup", meetGroup);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> createTemplateParameters(final PushTask pushTask, PushTarget pushTarget) {
        MeetGroup meetGroup = (MeetGroup)pushTarget.getExtend().get("meetGroup");
        return new HashMap<String, Object>(){
            {
                this.put("hour", pushTask.getTaskSceneCustomConfig());
            }
        };
    }

    @Override
    public PushScene of() {
        return PushScene.EXPIRE_MEET_REQUEST;
    }
}

