/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupDao;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MeetTimeoutFeedbackPushSceneService
extends AbstractTimerPushSceneService {
    private static final Logger log = LoggerFactory.getLogger(MeetTimeoutFeedbackPushSceneService.class);
    private final IMeetGroupService meetGroupService;

    public MeetTimeoutFeedbackPushSceneService(IPushTaskService pushTaskService, Fetcher fetcher, IMeetGroupService meetGroupService) {
        super(pushTaskService, fetcher);
        this.meetGroupService = meetGroupService;
    }

    @Override
    public PushScene of() {
        return PushScene.MEET_TIMEOUT_FEEDBACK;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        ArrayList pushTargets = Lists.newArrayList();
        try {
            QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"group_status", (Object)Constants.MeetGroupConst.GroupStatus.ACCEPT.value())).eq((Object)"meet_status", (Object)Constants.MeetGroupConst.MeetAddressStatus.CONFIRM.value())).lt((Object)"meet_time_start", (Object)LocalDateTime.now().minusHours(48L))).lt((Object)"push_count", (Object)1);
            List<MeetGroupDao> timeoutList = this.meetGroupService.listDao((Wrapper<MeetGroup>)queryWrapper);
            for (MeetGroupDao meetGroup : timeoutList) {
                try {
                    PushTarget pushTarget;
                    HashMap map;
                    Integer meetInviteUserResult = meetGroup.getMeetInviteUserResult();
                    Integer meetAcceptUserResult = meetGroup.getMeetAcceptUserResult();
                    if (Objects.isNull(meetInviteUserResult)) {
                        map = Maps.newHashMap();
                        map.put("nickName", meetGroup.getAcceptUserBasicInfo().getNickname());
                        pushTarget = new PushTarget().setUserId(meetGroup.getInviteUserId()).setExtend(map);
                        pushTargets.add(pushTarget);
                    }
                    if (Objects.isNull(meetAcceptUserResult)) {
                        map = Maps.newHashMap();
                        map.put("nickName", meetGroup.getInviteUserBasicInfo().getNickname());
                        pushTarget = new PushTarget().setUserId(meetGroup.getAcceptUserId()).setExtend(map);
                        pushTargets.add(pushTarget);
                    }
                    meetGroup.setPushCount(Optional.ofNullable(meetGroup.getPushCount()).orElse(0) + 1);
                    this.meetGroupService.updateById(meetGroup);
                }
                catch (Exception e) {
                    log.error("handleMeetResultTimeout: {}", (Object)meetGroup, (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("schedule:", (Throwable)e);
        }
        return pushTargets;
    }

    @Override
    public Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        final String nickName = (String)pushTarget.getExtend().get("nickName");
        return new HashMap<String, Object>(){
            {
                this.put("nickName", nickName);
            }
        };
    }
}

