/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.dal.service.IUserLoveConditionService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class NoLoveCondtionTimerPushSceneService
extends AbstractTimerPushSceneService {
    private final IUserService userService;
    private final IUserLoveConditionService userLoveConditionService;

    public NoLoveCondtionTimerPushSceneService(IPushTaskService pushTaskService, Fetcher fetcher, IUserService userService, IUserLoveConditionService userLoveConditionService) {
        super(pushTaskService, fetcher);
        this.userService = userService;
        this.userLoveConditionService = userLoveConditionService;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.lt(UserLoveCondition::getInfoCompleteProgress, (Object)100);
        lambdaQueryWrapper.apply("DATE_ADD(create_time, INTERVAL " + pushTask.getTaskEndOfLife() + " DAY) >= NOW()", new Object[0]);
        List userLoveConditionList = this.userLoveConditionService.list((Wrapper)lambdaQueryWrapper);
        return userLoveConditionList.stream().map(new Function<UserLoveCondition, PushTarget>(){

            @Override
            public PushTarget apply(UserLoveCondition userLoveCondition) {
                return new PushTarget().setUserId(userLoveCondition.getUserId());
            }
        }).collect(Collectors.toList());
    }

    @Override
    public PushScene of() {
        return PushScene.NO_LOVE_CONDTION;
    }
}

