/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class RegisterSuccessNotUseTimerPushSceneService
extends AbstractTimerPushSceneService {
    private final IUserService userService;

    public RegisterSuccessNotUseTimerPushSceneService(IPushTaskService pushTaskService, Fetcher fetcher, IUserService userService) {
        super(pushTaskService, fetcher);
        this.userService = userService;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.isNotNull(User::getRegisterFinishTime);
        lambdaQueryWrapper.isNotNull(User::getPushClientid);
        lambdaQueryWrapper.apply("DATE_ADD(register_finish_time, INTERVAL 24 HOUR) <= NOW()", new Object[0]);
        lambdaQueryWrapper.apply("DATE_ADD(last_on_line_time, INTERVAL 24 HOUR) < NOW()", new Object[0]);
        lambdaQueryWrapper.apply("DATE_ADD(create_time, INTERVAL " + pushTask.getTaskEndOfLife() + " DAY) >= NOW()", new Object[0]);
        List userList = this.userService.list((Wrapper)lambdaQueryWrapper);
        return userList.stream().map(new Function<User, PushTarget>(){

            @Override
            public PushTarget apply(User user) {
                return new PushTarget().setUserId(user.getId());
            }
        }).collect(Collectors.toList());
    }

    @Override
    public PushScene of() {
        return PushScene.REGISTER_SUCCESS_24H_NOT_USE;
    }
}

