/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.scheduler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.service.IActivityService;
import com.bxm.lovelink.common.dal.service.IActivityUserMutualSelectionService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityEndMutualSelectResultScheduler {
    private static final Logger log = LoggerFactory.getLogger(ActivityEndMutualSelectResultScheduler.class);
    private final IActivityService activityService;
    private final IActivityUserMutualSelectionService activityUserMutualSelectionService;

    public ActivityEndMutualSelectResultScheduler(IActivityService activityService, IActivityUserMutualSelectionService activityUserMutualSelectionService) {
        this.activityService = activityService;
        this.activityUserMutualSelectionService = activityUserMutualSelectionService;
    }

    public void schedule() {
        LocalDateTime now = LocalDateTime.now();
        List list = this.activityService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().lt(Activity::getActivityEndTime, (Object)now)).eq(Activity::getActivityStatus, (Object)1));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (Activity activity : list) {
            this.activityUserMutualSelectionService.generateMutualSelectResult(activity.getId());
        }
    }
}

