/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.scheduler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.UserOrder;
import com.bxm.lovelink.common.dal.service.IActivityService;
import com.bxm.lovelink.common.dal.service.IUserOrderService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityOrderTimeoutScheduler {
    private static final Logger log = LoggerFactory.getLogger(ActivityOrderTimeoutScheduler.class);
    private final IUserOrderService userOrderService;
    private final IActivityService activityService;

    public ActivityOrderTimeoutScheduler(IUserOrderService userOrderService, IActivityService activityService) {
        this.userOrderService = userOrderService;
        this.activityService = activityService;
    }

    public void schedule() {
        List userOrders = this.userOrderService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().lt(UserOrder::getStatus, (Object)2)).eq(UserOrder::getProductType, (Object)4)).lt(UserOrder::getCreateTime, (Object)LocalDateTime.now().minusMinutes(10L)));
        if (CollectionUtils.isEmpty((Collection)userOrders)) {
            return;
        }
        log.info("\u91ca\u653e{}\u7b14\u8d85\u65f6\u672a\u652f\u4ed8\u8ba2\u5355\u7684\u6d3b\u52a8\u540d\u989d", (Object)userOrders.size());
        for (UserOrder userOrder : userOrders) {
            try {
                this.activityService.releaseStock(userOrder.getOrderNum());
            }
            catch (Exception e) {
                log.error("\u6d3b\u52a8\u8ba2\u5355\u8d85\u65f6\u672a\u652f\u4ed8\uff0c\u91ca\u653e\u6d3b\u52a8\u540d\u989d\u5931\u8d25, orderNum:{}", (Object)userOrder.getOrderNum(), (Object)e);
            }
        }
    }
}

