/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.scheduler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupDao;
import com.bxm.lovelink.common.dal.manager.MeetGroupManager;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class MeetGroupInviteTimeoutScheduler {
    private static final Logger log = LoggerFactory.getLogger(MeetGroupInviteTimeoutScheduler.class);
    private final IMeetGroupService meetGroupService;
    private final MeetGroupManager meetGroupManager;

    public MeetGroupInviteTimeoutScheduler(IMeetGroupService meetGroupService, MeetGroupManager meetGroupManager) {
        this.meetGroupService = meetGroupService;
        this.meetGroupManager = meetGroupManager;
    }

    @Scheduled(cron="0 * * * * ?")
    public void schedule() {
        try {
            QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"group_status", (Object)Constants.MeetGroupConst.GroupStatus.WAIT_ACCEPT.value())).lt((Object)"invite_expire_time", (Object)LocalDateTime.now());
            List<MeetGroupDao> timeoutList = this.meetGroupService.listDao((Wrapper<MeetGroup>)queryWrapper);
            for (MeetGroupDao meetGroup : timeoutList) {
                try {
                    this.meetGroupManager.handleInviteTimeout(meetGroup);
                }
                catch (Exception e) {
                    log.error("handleInviteTimeout: {}", (Object)meetGroup, (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("schedule:", (Throwable)e);
        }
    }
}

