/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.scheduler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bxm.lovelink.common.dal.entity.UserCert;
import com.bxm.lovelink.common.dal.service.IUserCertService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class UserCertScheduler {
    private static final Logger log = LoggerFactory.getLogger(UserCertScheduler.class);
    private final IUserCertService userCertService;

    public UserCertScheduler(IUserCertService userCertService) {
        this.userCertService = userCertService;
    }

    @Scheduled(cron="*/10 * * * * ?")
    public void updateCert() {
        List list = this.userCertService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UserCert::getCertStatus, (Object)UserCert.STATUS_CHECKING)).ne(UserCert::getCertType, (Object)UserCert.TYPE_REAL_NAME));
        list.forEach(u -> {
            try {
                this.userCertService.updateCertByApi((UserCert)u);
            }
            catch (Exception e) {
                log.error("Update cert error ", (Throwable)e);
            }
        });
    }
}

