/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.scheduler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.service.IUserOnlineService;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class UserOnLineStatusScheduler {
    private final IUserOtherInfoService userOtherInfoService;
    private final ExecutorService executor;
    private final Fetcher fetcher;
    private final IUserOnlineService userOnlineService;

    public UserOnLineStatusScheduler(IUserOtherInfoService userOtherInfoService, Pair pair, Fetcher fetcher, IUserOnlineService userOnlineService) {
        this.userOtherInfoService = userOtherInfoService;
        this.fetcher = fetcher;
        this.userOnlineService = userOnlineService;
        this.executor = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("user_online_status"));
    }

    @Scheduled(cron="0 */5 * * * ?")
    public void noOnline() {
        Map<Long, Long> map = this.userOtherInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserOtherInfo::getOnlineStatus, (Object)1)).select(new SFunction[]{UserOtherInfo::getId, UserOtherInfo::getUserId})).stream().collect(Collectors.toMap(UserOtherInfo::getUserId, UserOtherInfo::getId));
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            Long userId = entry.getKey();
            Long otherId = entry.getValue();
            this.executor.execute(() -> {
                Boolean online = this.userOnlineService.getOnline(userId);
                if (!online.booleanValue()) {
                    this.userOtherInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UserOtherInfo::getId, (Object)otherId)).eq(UserOtherInfo::getOnlineStatus, (Object)1)).set(UserOtherInfo::getOnlineStatus, (Object)0));
                }
            });
        }
    }
}

