/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.utils;

import com.alibaba.excel.EasyExcel;
import com.bxm.lovelink.common.utils.ExcelDataListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static <T> void exportExcel(HttpServletResponse response, String title, Class<T> clazz, List<T> dataList) {
        try {
            String fileName = URLEncoder.encode(title, "UTF-8");
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), clazz).sheet(title).doWrite(dataList);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u6587\u4ef6\u540d\u8f6c\u7801\u5931\u8d25");
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25");
        }
    }

    public static <T> List<T> importExcelByPathName(String pathName, Class<T> clazz) {
        ExcelDataListener listener = new ExcelDataListener();
        try {
            EasyExcel.read((String)pathName, clazz, listener).sheet().doRead();
            return listener.getResult();
        }
        catch (Exception e) {
            log.error("\u3010excel-read\u3011\u8bfb\u53d6excel\u5f02\u5e38\uff0cclazz:{}", clazz, (Object)e);
            return Collections.emptyList();
        }
    }

    public static <T> List<T> importExcelByIo(InputStream in, Class<T> clazz) {
        ExcelDataListener listener = new ExcelDataListener();
        try {
            EasyExcel.read((InputStream)in, clazz, listener).sheet().doRead();
            return listener.getResult();
        }
        catch (Exception e) {
            log.error("\u3010excel-read\u3011\u8bfb\u53d6excel\u5f02\u5e38\uff0cclazz:{}", clazz, (Object)e);
            return Collections.emptyList();
        }
    }
}

