/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.utils;

public class GeoDistanceUtils {
    private static final double EARTH_RADIUS = 6371000.0;

    public static Double calculateDistance(Double lat1, Double lon1, Double lat2, Double lon2) {
        if (lat1 == null || lon1 == null || lat2 == null || lon2 == null) {
            return null;
        }
        double radLat1 = Math.toRadians(lat1);
        double radLat2 = Math.toRadians(lat2);
        double deltaLat = radLat2 - radLat1;
        double deltaLon = Math.toRadians(lon2 - lon1);
        double a = Math.sin(deltaLat / 2.0) * Math.sin(deltaLat / 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.sin(deltaLon / 2.0) * Math.sin(deltaLon / 2.0);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        return 6371000.0 * c;
    }

    public static void main(String[] args) {
        double lat1 = 39.9042;
        double lon1 = 116.4074;
        double lat2 = 31.2304;
        double lon2 = 121.4737;
        double distance = GeoDistanceUtils.calculateDistance(lat1, lon1, lat2, lon2);
        System.out.printf("\u4e24\u5730\u4e4b\u95f4\u7684\u8ddd\u79bb\u4e3a\uff1a%.2f \u7c73%n", distance);
    }
}

