package com.bxm.lovelink.constant;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * @author tangxiao
 * @date 2023/7/25
 * @since 1.0
 */
public class RedisKeys {
    public static Integer expireTimeInSecond = 7 * 24 * 60 * 60;

    public static Integer expireTimeOneDay = 24 * 60 * 60;

    public static Integer expireTimeOneYear = 365 * 24 * 60 * 60;

    public static KeyGenerator ipOrUaKey(String key) {
        return () -> KeyBuilder.build("AI", "LOVELINK", key);
    }

    public static KeyGenerator loginCaptchaKey(String mobile) {
        return () -> KeyBuilder.build("lovelink", "login", "captcha", mobile);
    }

    public static KeyGenerator loginCaptchaLimitKey(String mobile) {
        return () -> KeyBuilder.build("lovelink", "login", "captcha", "limit", mobile);
    }

    public static KeyGenerator userCertLimitKey(Long userId, Integer type) {
        return () -> KeyBuilder.build("lovelink", "user", "cert", "limit", userId, type);
    }

    public static KeyGenerator userActiveTime(Long userId) {
        return () -> KeyBuilder.build("lovelink", "user", "active", "time", userId);
    }

    public static KeyGenerator userCreateLock(String uniqueKey) {
        return () -> KeyBuilder.build("lovelink", "user", "create", "lock", uniqueKey);
    }

    public static KeyGenerator userCertLock(Long userId, Integer type) {
        return () -> KeyBuilder.build("lovelink", "user", "cert", "lock", userId, type);
    }

    public static KeyGenerator userCertCount(Long userId, Integer type) {
        return () -> KeyBuilder.build("lovelink", "user", "cert", "count", userId, type);
    }

    public static KeyGenerator userBasicInfoUpdateLock(Long userId) {
        return () -> KeyBuilder.build("lovelink", "user", "basicInfo", "update", "lock", userId);
    }

    public static KeyGenerator userBasicInfoCache(Long userId) {
        return () -> KeyBuilder.build("lovelink", "user", "basicInfo", "cache", userId);
    }

    public static KeyGenerator userLoveConditionCache(Long userId) {
        return () -> KeyBuilder.build("lovelink", "user", "loveCondition", "cache", userId);
    }

    public static KeyGenerator userOtherCache(Long userId) {
        return () -> KeyBuilder.build("lovelink", "user", "other", "cache", userId);
    }

    public static KeyGenerator userCache(Long userId) {
        return () -> KeyBuilder.build("lovelink", "user", "info", "cache", userId);
    }

    public static KeyGenerator cacheSyncLock(String key) {
        return () -> KeyBuilder.build("lovelink", "user", "cache", "sync", "lock", key);
    }

    public static KeyGenerator cacheMark() {
        return () -> KeyBuilder.build("lovelink", "user", "cache", "mark");
    }


    public static KeyGenerator userTimeExposeCount(Object userId) {
        return () -> KeyBuilder.build("lovelink", "user", "expose", "time", "count", userId);
    }

    public static KeyGenerator swipeCountKey(Long userId, String date) {
        return () -> KeyBuilder.build("lovelink", "user", "swipe", "count", userId, date);
    }

    public static KeyGenerator inviteUserRewardCount(Long userId) {
        return () -> KeyBuilder.build("lovelink", "invite", "user", "reward", "count", userId);
    }


    /**
     * 用户心动key
     *
     * @return
     */
    public static KeyGenerator userBeLoveCount() {
        return () -> KeyBuilder.build("lovelink", "be", "love", "count");
    }

    /**
     * 未读消息数量
     *
     * @param sessionId 会话ID
     * @return
     */
    public static KeyGenerator hashChatUnreadNum(Long sessionId) {
        return () -> KeyBuilder.build("lovelink", "chat", "unread_num", "session", sessionId);
    }

    public static KeyGenerator userFirstAppointDetailPage(Long userId) {
        return () -> KeyBuilder.build("lovelink", "user", "first", "appoint", "detail", "page", userId);
    }

    public static KeyGenerator activityRegisterLock(Long activityId, Long userId) {
        return () -> KeyBuilder.build("lovelink", "activity", "register", "lock", activityId, userId);
    }

    public static KeyGenerator hashMeetGroupUnreadCount(Long userId) {
        return () -> KeyBuilder.build("lovelink", "meet_group", "unread_count", "user", userId);
    }

    /**
     * 记录今天已曝光引导卡片
     */
    public static KeyGenerator userTodayExposeGuideCard(Long userId, String date) {
        return () -> KeyBuilder.build("lovelink", "user", "guide", "card", "today", userId, date);
    }

    /**
     * 用户已经查看过的用户列表，不过期的
     *
     * @param userId 用户ID
     * @return JSON格式的用户ID列表
     */
    public static KeyGenerator stringUserShowedList(Long userId) {
        return () -> KeyBuilder.build("lovelink", "rs", "user", "show", userId);
    }

    /**
     * 指定用户指定日期被邀约见面次数
     *
     * @param userId 指定用户
     * @param date   指定日期
     * @return 计数器
     */
    public static KeyGenerator stringUserBeInvitedCount(Long userId, String date) {
        return () -> KeyBuilder.build("lovelink", "rs", "invited_count", userId, date);
    }

    /**
     * 指定日期被邀约指定见面次数的用户列表
     *
     * @param count 指定见面次数
     * @param date  指定日期
     * @return JSON格式的用户ID列表
     */
    public static KeyGenerator stringBeInvitedTop(int count, String date) {
        return () -> KeyBuilder.build("lovelink", "rs", "invited_count_" + count, date);
    }

    public static KeyGenerator activityOrderTimeoutLock(String orderNum) {
        return () -> KeyBuilder.build("lovelink", "activity", "order", "timeout", "lock", orderNum);
    }

    /**
     * userId > userNumber 映射关系
     *
     * @param userId
     * @return
     */
    public static KeyGenerator stringUserId2UserNumberMapping(Long userId) {
        return () -> KeyBuilder.build("lovelink", "user", "id_number_mapping", userId);
    }

    public static KeyGenerator activityUserSelectionLock(Long activityId, Long userId) {
        return () -> KeyBuilder.build("lovelink", "activity", "user", "selection", activityId, userId);
    }

    public static KeyGenerator userVisitRecordLock(Long userId, Long targetUserId) {
        return () -> KeyBuilder.build("lovelink", "user", "visit", "record", userId, targetUserId);
    }


    public static KeyGenerator userGiveStageLock(Long userId, Integer stage) {
        return () -> KeyBuilder.build("lovelink", "user", "give", "stage", userId, stage);
    }
}
