/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.constant;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

public class RedisKeys {
    public static Integer expireTimeInSecond = 604800;
    public static Integer expireTimeOneDay = 86400;
    public static Integer expireTimeOneYear = 31536000;

    public static KeyGenerator ipOrUaKey(String key) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AI", "LOVELINK", key});
    }

    public static KeyGenerator loginCaptchaKey(String mobile) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "login", "captcha", mobile});
    }

    public static KeyGenerator loginCaptchaLimitKey(String mobile) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "login", "captcha", "limit", mobile});
    }

    public static KeyGenerator userCertLimitKey(Long userId, Integer type) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "cert", "limit", userId, type});
    }

    public static KeyGenerator userActiveTime(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "active", "time", userId});
    }

    public static KeyGenerator userCreateLock(String uniqueKey) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "create", "lock", uniqueKey});
    }

    public static KeyGenerator userCertLock(Long userId, Integer type) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "cert", "lock", userId, type});
    }

    public static KeyGenerator userCertCount(Long userId, Integer type) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "cert", "count", userId, type});
    }

    public static KeyGenerator userBasicInfoUpdateLock(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "basicInfo", "update", "lock", userId});
    }

    public static KeyGenerator userBasicInfoCache(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "basicInfo", "cache", userId});
    }

    public static KeyGenerator userLoveConditionCache(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "loveCondition", "cache", userId});
    }

    public static KeyGenerator userOtherCache(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "other", "cache", userId});
    }

    public static KeyGenerator userCache(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "info", "cache", userId});
    }

    public static KeyGenerator cacheSyncLock(String key) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "cache", "sync", "lock", key});
    }

    public static KeyGenerator cacheMark() {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "cache", "mark"});
    }

    public static KeyGenerator userTimeExposeCount(Object userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "expose", "time", "count", userId});
    }

    public static KeyGenerator swipeCountKey(Long userId, String date) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "swipe", "count", userId, date});
    }

    public static KeyGenerator inviteUserRewardCount(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "invite", "user", "reward", "count", userId});
    }

    public static KeyGenerator userBeLoveCount() {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "be", "love", "count"});
    }

    public static KeyGenerator hashChatUnreadNum(Long sessionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "chat", "unread_num", "session", sessionId});
    }

    public static KeyGenerator userFirstAppointDetailPage(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "first", "appoint", "detail", "page", userId});
    }

    public static KeyGenerator activityRegisterLock(Long activityId, Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "activity", "register", "lock", activityId, userId});
    }

    public static KeyGenerator hashMeetGroupUnreadCount(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "meet_group", "unread_count", "user", userId});
    }

    public static KeyGenerator userTodayExposeGuideCard(Long userId, String date) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "guide", "card", "today", userId, date});
    }

    public static KeyGenerator stringUserShowedList(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "rs", "user", "show", userId});
    }

    public static KeyGenerator stringUserBeInvitedCount(Long userId, String date) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "rs", "invited_count", userId, date});
    }

    public static KeyGenerator stringBeInvitedTop(int count, String date) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "rs", "invited_count_" + count, date});
    }

    public static KeyGenerator activityOrderTimeoutLock(String orderNum) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "activity", "order", "timeout", "lock", orderNum});
    }

    public static KeyGenerator stringUserId2UserNumberMapping(Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "id_number_mapping", userId});
    }

    public static KeyGenerator activityUserSelectionLock(Long activityId, Long userId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "activity", "user", "selection", activityId, userId});
    }

    public static KeyGenerator userVisitRecordLock(Long userId, Long targetUserId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "visit", "record", userId, targetUserId});
    }

    public static KeyGenerator userGiveStageLock(Long userId, Integer stage) {
        return () -> KeyBuilder.build((Object[])new Object[]{"lovelink", "user", "give", "stage", userId, stage});
    }
}

