/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.integration.apple;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class AppleAuthIntegration {
    private static final String APPLE_KEYS_URL = "https://appleid.apple.com/auth/keys";
    private static final String APPLE_ISSUER = "https://appleid.apple.com";
    private final Cache<String, PublicKey> keyCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build();

    public String auth(String identityToken, String bundleId) {
        try {
            String kid = this.getKidFromToken(identityToken);
            PublicKey publicKey = (PublicKey)this.keyCache.get((Object)kid, () -> this.getPublicKey(kid));
            Claims claims = (Claims)Jwts.parserBuilder().requireIssuer(APPLE_ISSUER).requireAudience(bundleId).setSigningKey((Key)publicKey).build().parseClaimsJws(identityToken).getBody();
            return claims.getSubject();
        }
        catch (Exception e) {
            throw new RuntimeException("Apple identityToken validation failed", e);
        }
    }

    private String getKidFromToken(String identityToken) {
        String[] parts = identityToken.split("\\.");
        String header = new String(Base64.getUrlDecoder().decode(parts[0]));
        JSONObject headerJson = JSON.parseObject((String)header);
        return headerJson.getString("kid");
    }

    private PublicKey getPublicKey(String kid) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        String keysResponse = (String)restTemplate.getForObject(APPLE_KEYS_URL, String.class, new Object[0]);
        JSONObject keysJson = JSON.parseObject((String)keysResponse);
        JSONArray keys = keysJson.getJSONArray("keys");
        JSONObject key = null;
        for (int i = 0; i < keys.size(); ++i) {
            JSONObject currentKey = keys.getJSONObject(i);
            if (!kid.equals(currentKey.getString("kid"))) continue;
            key = currentKey;
            break;
        }
        if (key == null) {
            throw new RuntimeException("Public key not found for kid: " + kid);
        }
        BigInteger n = new BigInteger(1, Base64.getUrlDecoder().decode(key.getString("n")));
        BigInteger e = new BigInteger(1, Base64.getUrlDecoder().decode(key.getString("e")));
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(n, e);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(publicKeySpec);
    }
}

