/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.integration.apple;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.lovelink.integration.apple.AppleProperties;
import com.bxm.warcar.utils.HttpClientHelper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={AppleProperties.class})
public class ApplePayIntegration {
    private static final Logger log = LoggerFactory.getLogger(ApplePayIntegration.class);
    private final AppleProperties appleProperties;
    private final HttpClient httpClient = HttpClientHelper.createHttpClient((int)10, (int)10, (int)1000, (int)2000, (int)3000);

    public VerifyReceiptResponse verifyReceipt(String receipt, boolean useSandbox) {
        String url = useSandbox ? this.appleProperties.getSandboxVerifyReceiptUrl() : this.appleProperties.getVerifyReceiptUrl();
        HttpPost post = new HttpPost(url);
        VerifyReceiptRequest request = new VerifyReceiptRequest().setReceiptData(receipt).setPassword(this.appleProperties.getSharedSecret());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)request), StandardCharsets.UTF_8));
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (statusCode != HttpStatus.OK.value() || StringUtils.isEmpty((String)result)) {
                log.error("Apple pay receipt verification failed. receipt:{}, status:{}, result:{}", new Object[]{receipt, statusCode, result});
                throw new RuntimeException("Failed to verify Apple receipt, http status: " + statusCode);
            }
            VerifyReceiptResponse receiptResponse = (VerifyReceiptResponse)JSON.parseObject((String)result, VerifyReceiptResponse.class);
            if (receiptResponse == null) {
                log.error("Apple pay receipt verification failed, response is null. receipt:{}, result:{}", (Object)receipt, (Object)result);
                throw new RuntimeException("Failed to parse Apple receipt response.");
            }
            if (receiptResponse.getStatus() == 21007 && !useSandbox) {
                log.info("Receipt is for sandbox, retrying with sandbox URL. receipt:{}", (Object)receipt);
                VerifyReceiptResponse verifyReceiptResponse = this.verifyReceipt(receipt, true);
                return verifyReceiptResponse;
            }
            VerifyReceiptResponse verifyReceiptResponse = receiptResponse;
            return verifyReceiptResponse;
        }
        catch (Exception e) {
            log.error("Error verifying Apple pay receipt. receipt:{}", (Object)receipt, (Object)e);
            throw new RuntimeException("An unexpected error occurred during Apple receipt verification.");
        }
        finally {
            post.releaseConnection();
        }
    }

    public String verifyReceipt(String receipt, String url) {
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)new VerifyReceiptRequest().setReceiptData(receipt)), StandardCharsets.UTF_8));
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int status = response.getStatusLine().getStatusCode();
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (status != HttpStatus.OK.value() || StringUtils.isEmpty((String)result)) {
                log.error("apple pay receipt fail receipt:{},status:{},result:{}", new Object[]{receipt, status, result});
                throw new IllegalStateException("apple pay receipt error");
            }
            VerifyReceiptResponse receiptResponse = (VerifyReceiptResponse)JSON.parseObject((String)result, VerifyReceiptResponse.class);
            if (Objects.isNull(receiptResponse) || !receiptResponse.isSuccess2()) {
                log.error("apple pay receipt fail receipt:{},result:{}", (Object)receipt, (Object)result);
                throw new IllegalStateException("apple pay receipt error");
            }
            String string = receiptResponse.getOutOrderId();
            return string;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("apple pay error receipt:{}", (Object)receipt, (Object)e);
            throw new RuntimeException("apple pay receipt error");
        }
        finally {
            post.releaseConnection();
        }
    }

    public ApplePayIntegration(AppleProperties appleProperties) {
        this.appleProperties = appleProperties;
    }

    public static class VerifyReceiptResponse {
        private Integer status;
        private ReceiptInfo receipt;
        @JSONField(name="latest_receipt_info")
        private List<InApp> latestReceiptInfo;
        @JSONField(name="pending_renewal_info")
        private List<PendingRenewalInfo> pendingRenewalInfo;

        public boolean isSuccess() {
            return Objects.equals(this.status, 0);
        }

        public String getOutOrderId() {
            return ((InApp)this.receipt.inAppList.get(0)).originalTransactionId;
        }

        public boolean isSuccess2() {
            return Objects.equals(this.status, 0) && Objects.nonNull(this.receipt) && CollectionUtils.isNotEmpty((Collection)this.receipt.inAppList) && StringUtils.isNotEmpty((String)((InApp)this.receipt.inAppList.get(0)).originalTransactionId);
        }

        public Integer getStatus() {
            return this.status;
        }

        public ReceiptInfo getReceipt() {
            return this.receipt;
        }

        public List<InApp> getLatestReceiptInfo() {
            return this.latestReceiptInfo;
        }

        public List<PendingRenewalInfo> getPendingRenewalInfo() {
            return this.pendingRenewalInfo;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public void setReceipt(ReceiptInfo receipt) {
            this.receipt = receipt;
        }

        public void setLatestReceiptInfo(List<InApp> latestReceiptInfo) {
            this.latestReceiptInfo = latestReceiptInfo;
        }

        public void setPendingRenewalInfo(List<PendingRenewalInfo> pendingRenewalInfo) {
            this.pendingRenewalInfo = pendingRenewalInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifyReceiptResponse)) {
                return false;
            }
            VerifyReceiptResponse other = (VerifyReceiptResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            ReceiptInfo this$receipt = this.getReceipt();
            ReceiptInfo other$receipt = other.getReceipt();
            if (this$receipt == null ? other$receipt != null : !((Object)this$receipt).equals(other$receipt)) {
                return false;
            }
            List<InApp> this$latestReceiptInfo = this.getLatestReceiptInfo();
            List<InApp> other$latestReceiptInfo = other.getLatestReceiptInfo();
            if (this$latestReceiptInfo == null ? other$latestReceiptInfo != null : !((Object)this$latestReceiptInfo).equals(other$latestReceiptInfo)) {
                return false;
            }
            List<PendingRenewalInfo> this$pendingRenewalInfo = this.getPendingRenewalInfo();
            List<PendingRenewalInfo> other$pendingRenewalInfo = other.getPendingRenewalInfo();
            return !(this$pendingRenewalInfo == null ? other$pendingRenewalInfo != null : !((Object)this$pendingRenewalInfo).equals(other$pendingRenewalInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VerifyReceiptResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            ReceiptInfo $receipt = this.getReceipt();
            result = result * 59 + ($receipt == null ? 43 : ((Object)$receipt).hashCode());
            List<InApp> $latestReceiptInfo = this.getLatestReceiptInfo();
            result = result * 59 + ($latestReceiptInfo == null ? 43 : ((Object)$latestReceiptInfo).hashCode());
            List<PendingRenewalInfo> $pendingRenewalInfo = this.getPendingRenewalInfo();
            result = result * 59 + ($pendingRenewalInfo == null ? 43 : ((Object)$pendingRenewalInfo).hashCode());
            return result;
        }

        public String toString() {
            return "ApplePayIntegration.VerifyReceiptResponse(status=" + this.getStatus() + ", receipt=" + this.getReceipt() + ", latestReceiptInfo=" + this.getLatestReceiptInfo() + ", pendingRenewalInfo=" + this.getPendingRenewalInfo() + ")";
        }

        public static class InApp {
            @JSONField(name="original_transaction_id")
            private String originalTransactionId;
            @JSONField(name="transaction_id")
            private String transactionId;
            @JSONField(name="product_id")
            private String productId;
            @JSONField(name="purchase_date_ms")
            private String purchaseDateMs;
            @JSONField(name="expires_date_ms")
            private String expiresDateMs;

            public String getOriginalTransactionId() {
                return this.originalTransactionId;
            }

            public String getTransactionId() {
                return this.transactionId;
            }

            public String getProductId() {
                return this.productId;
            }

            public String getPurchaseDateMs() {
                return this.purchaseDateMs;
            }

            public String getExpiresDateMs() {
                return this.expiresDateMs;
            }

            public void setOriginalTransactionId(String originalTransactionId) {
                this.originalTransactionId = originalTransactionId;
            }

            public void setTransactionId(String transactionId) {
                this.transactionId = transactionId;
            }

            public void setProductId(String productId) {
                this.productId = productId;
            }

            public void setPurchaseDateMs(String purchaseDateMs) {
                this.purchaseDateMs = purchaseDateMs;
            }

            public void setExpiresDateMs(String expiresDateMs) {
                this.expiresDateMs = expiresDateMs;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InApp)) {
                    return false;
                }
                InApp other = (InApp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$originalTransactionId = this.getOriginalTransactionId();
                String other$originalTransactionId = other.getOriginalTransactionId();
                if (this$originalTransactionId == null ? other$originalTransactionId != null : !this$originalTransactionId.equals(other$originalTransactionId)) {
                    return false;
                }
                String this$transactionId = this.getTransactionId();
                String other$transactionId = other.getTransactionId();
                if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
                    return false;
                }
                String this$productId = this.getProductId();
                String other$productId = other.getProductId();
                if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
                    return false;
                }
                String this$purchaseDateMs = this.getPurchaseDateMs();
                String other$purchaseDateMs = other.getPurchaseDateMs();
                if (this$purchaseDateMs == null ? other$purchaseDateMs != null : !this$purchaseDateMs.equals(other$purchaseDateMs)) {
                    return false;
                }
                String this$expiresDateMs = this.getExpiresDateMs();
                String other$expiresDateMs = other.getExpiresDateMs();
                return !(this$expiresDateMs == null ? other$expiresDateMs != null : !this$expiresDateMs.equals(other$expiresDateMs));
            }

            protected boolean canEqual(Object other) {
                return other instanceof InApp;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $originalTransactionId = this.getOriginalTransactionId();
                result = result * 59 + ($originalTransactionId == null ? 43 : $originalTransactionId.hashCode());
                String $transactionId = this.getTransactionId();
                result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
                String $productId = this.getProductId();
                result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
                String $purchaseDateMs = this.getPurchaseDateMs();
                result = result * 59 + ($purchaseDateMs == null ? 43 : $purchaseDateMs.hashCode());
                String $expiresDateMs = this.getExpiresDateMs();
                result = result * 59 + ($expiresDateMs == null ? 43 : $expiresDateMs.hashCode());
                return result;
            }

            public String toString() {
                return "ApplePayIntegration.VerifyReceiptResponse.InApp(originalTransactionId=" + this.getOriginalTransactionId() + ", transactionId=" + this.getTransactionId() + ", productId=" + this.getProductId() + ", purchaseDateMs=" + this.getPurchaseDateMs() + ", expiresDateMs=" + this.getExpiresDateMs() + ")";
            }
        }

        public static class ReceiptInfo {
            @JSONField(name="in_app")
            private List<InApp> inAppList;

            public List<InApp> getInAppList() {
                return this.inAppList;
            }

            public void setInAppList(List<InApp> inAppList) {
                this.inAppList = inAppList;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ReceiptInfo)) {
                    return false;
                }
                ReceiptInfo other = (ReceiptInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<InApp> this$inAppList = this.getInAppList();
                List<InApp> other$inAppList = other.getInAppList();
                return !(this$inAppList == null ? other$inAppList != null : !((Object)this$inAppList).equals(other$inAppList));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ReceiptInfo;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<InApp> $inAppList = this.getInAppList();
                result = result * 59 + ($inAppList == null ? 43 : ((Object)$inAppList).hashCode());
                return result;
            }

            public String toString() {
                return "ApplePayIntegration.VerifyReceiptResponse.ReceiptInfo(inAppList=" + this.getInAppList() + ")";
            }
        }

        public static class PendingRenewalInfo {
            @JSONField(name="auto_renew_product_id")
            private String autoRenewProductId;
            @JSONField(name="auto_renew_status")
            private String autoRenewStatus;

            public String getAutoRenewProductId() {
                return this.autoRenewProductId;
            }

            public String getAutoRenewStatus() {
                return this.autoRenewStatus;
            }

            public void setAutoRenewProductId(String autoRenewProductId) {
                this.autoRenewProductId = autoRenewProductId;
            }

            public void setAutoRenewStatus(String autoRenewStatus) {
                this.autoRenewStatus = autoRenewStatus;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PendingRenewalInfo)) {
                    return false;
                }
                PendingRenewalInfo other = (PendingRenewalInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$autoRenewProductId = this.getAutoRenewProductId();
                String other$autoRenewProductId = other.getAutoRenewProductId();
                if (this$autoRenewProductId == null ? other$autoRenewProductId != null : !this$autoRenewProductId.equals(other$autoRenewProductId)) {
                    return false;
                }
                String this$autoRenewStatus = this.getAutoRenewStatus();
                String other$autoRenewStatus = other.getAutoRenewStatus();
                return !(this$autoRenewStatus == null ? other$autoRenewStatus != null : !this$autoRenewStatus.equals(other$autoRenewStatus));
            }

            protected boolean canEqual(Object other) {
                return other instanceof PendingRenewalInfo;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $autoRenewProductId = this.getAutoRenewProductId();
                result = result * 59 + ($autoRenewProductId == null ? 43 : $autoRenewProductId.hashCode());
                String $autoRenewStatus = this.getAutoRenewStatus();
                result = result * 59 + ($autoRenewStatus == null ? 43 : $autoRenewStatus.hashCode());
                return result;
            }

            public String toString() {
                return "ApplePayIntegration.VerifyReceiptResponse.PendingRenewalInfo(autoRenewProductId=" + this.getAutoRenewProductId() + ", autoRenewStatus=" + this.getAutoRenewStatus() + ")";
            }
        }
    }

    private static class VerifyReceiptRequest {
        @JSONField(name="receipt-data")
        private String receiptData;
        @JSONField(name="password")
        private String password;

        public String getReceiptData() {
            return this.receiptData;
        }

        public String getPassword() {
            return this.password;
        }

        public VerifyReceiptRequest setReceiptData(String receiptData) {
            this.receiptData = receiptData;
            return this;
        }

        public VerifyReceiptRequest setPassword(String password) {
            this.password = password;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifyReceiptRequest)) {
                return false;
            }
            VerifyReceiptRequest other = (VerifyReceiptRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$receiptData = this.getReceiptData();
            String other$receiptData = other.getReceiptData();
            if (this$receiptData == null ? other$receiptData != null : !this$receiptData.equals(other$receiptData)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VerifyReceiptRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $receiptData = this.getReceiptData();
            result = result * 59 + ($receiptData == null ? 43 : $receiptData.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "ApplePayIntegration.VerifyReceiptRequest(receiptData=" + this.getReceiptData() + ", password=" + this.getPassword() + ")";
        }
    }
}

