/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.integration.apple.notification;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bxm.lovelink.integration.apple.notification.CertificateUtil;
import com.bxm.lovelink.integration.apple.notification.JWSDecodedHeader;
import com.bxm.lovelink.integration.apple.notification.JWSRenewalInfoDecodedPayload;
import com.bxm.lovelink.integration.apple.notification.JWSTransactionDecodedPayload;
import com.bxm.lovelink.integration.apple.notification.NotificationDecoder;
import com.bxm.lovelink.integration.apple.notification.ResponseBodyV2DecodedPayload;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPublicKey;
import java.util.Base64;

public class NotificationDecoderImpl
implements NotificationDecoder {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private void verify(DecodedJWT jwt) throws JsonProcessingException, CertificateException {
        String header = new String(Base64.getDecoder().decode(jwt.getHeader()));
        JWSDecodedHeader decodedHeader = (JWSDecodedHeader)objectMapper.readValue(header, JWSDecodedHeader.class);
        PublicKey publicKey = CertificateUtil.x5c0ToKey(decodedHeader.getX5c()[0]);
        Algorithm.ECDSA256((ECPublicKey)((ECPublicKey)publicKey), null).verify(jwt);
    }

    @Override
    public ResponseBodyV2DecodedPayload decodePayload(String signedPayload) throws JsonProcessingException, CertificateException {
        DecodedJWT jwt = JWT.decode((String)signedPayload);
        this.verify(jwt);
        String payload = new String(Base64.getDecoder().decode(jwt.getPayload()));
        return (ResponseBodyV2DecodedPayload)objectMapper.readValue(payload, ResponseBodyV2DecodedPayload.class);
    }

    @Override
    public JWSRenewalInfoDecodedPayload decodeRenewalInfo(String signedRenewalInfo) {
        try {
            DecodedJWT jwt = JWT.decode((String)signedRenewalInfo);
            this.verify(jwt);
            String payload = new String(Base64.getDecoder().decode(jwt.getPayload()));
            return (JWSRenewalInfoDecodedPayload)objectMapper.readValue(payload, JWSRenewalInfoDecodedPayload.class);
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    @Override
    public JWSTransactionDecodedPayload decodeTransaction(String signedTransaction) {
        try {
            DecodedJWT jwt = JWT.decode((String)signedTransaction);
            this.verify(jwt);
            String payload = new String(Base64.getDecoder().decode(jwt.getPayload()));
            return (JWSTransactionDecodedPayload)objectMapper.readValue(payload, JWSTransactionDecodedPayload.class);
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    static {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

