/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.integration.identify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.lovelink.integration.identify.IdentifyProduct;
import com.bxm.lovelink.integration.identify.IdentifyResult;
import com.bxm.lovelink.integration.identify.YushanAES;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.utils.HttpClientHelper;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class IdentifyIntegration {
    private static final Logger log = LoggerFactory.getLogger(IdentifyIntegration.class);
    private static final String URL = "https://api.yushanshuju.com/credit-gw/service";
    private static final String TEST_URL = "http://122.152.195.249:21000/credit-gw/service";
    private static final String API_ID = "YSSJ644904121";
    private static final String API_KEY = "57526b705a5646685453457454524656";
    private final HttpClient httpClient = HttpClientHelper.createHttpClient((int)10, (int)10, (int)5000, (int)5000, (int)5000);
    private IdGenerator idGenerator;

    @Autowired
    @Qualifier(value="orderIdGenerator")
    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public IdentifyResult queryResult(String name, String cardNo, Integer certType) {
        IdentifyResult identifyResult = new IdentifyResult();
        String certResult = null;
        try {
            IdentifyProduct product = IdentifyProduct.getByCertType(certType);
            switch (product) {
                case MARRIAGE: {
                    certResult = JsonHelper.convert((Object)this.queryMarriage(name, cardNo));
                    break;
                }
                case CAR: {
                    certResult = JsonHelper.convert((Object)this.queryCar(cardNo));
                    break;
                }
                case EDUCATION: {
                    certResult = JsonHelper.convert((Object)this.queryEducation(name, cardNo));
                    break;
                }
            }
            identifyResult.setSuccess(true);
            identifyResult.setCertResult(certResult);
        }
        catch (Exception e) {
            identifyResult.setSuccess(false);
            JSONObject obj = new JSONObject();
            obj.put("errorMsg", (Object)e.getMessage());
            identifyResult.setCertResult(obj.toJSONString());
        }
        return identifyResult;
    }

    public MarriageData queryMarriage(String name, String cardNo) {
        MarriageRes marriageRes = this.execute(IdentifyProduct.MARRIAGE, new ReqData().setName(name).setCardNo(cardNo), MarriageRes.class);
        return (MarriageData)marriageRes.getRetdata();
    }

    public EducationData queryEducation(String name, String cardNo) {
        EducationRes educationRes = this.execute(IdentifyProduct.EDUCATION, new ReqData().setName(name).setCardNo(cardNo), EducationRes.class);
        List retdata = (List)educationRes.getRetdata();
        if (CollectionUtils.isEmpty((Collection)retdata)) {
            return null;
        }
        return (EducationData)retdata.get(retdata.size() - 1);
    }

    public CarData queryCar(String cardNo) {
        CarRes carRes = this.execute(IdentifyProduct.CAR, new ReqData().setCardNo(cardNo), CarRes.class);
        return (CarData)carRes.getRetdata();
    }

    private <T extends IdentifyCommonRes<?>> T execute(IdentifyProduct identifyProduct, ReqData reqData, Class<T> resClazz) {
        String requestId = this.idGenerator.next();
        String reqJson = JSON.toJSONString((Object)new IdentifyRequest().setRequest_sn(requestId).setAcct_id(API_ID).setProd_id(identifyProduct.getId()).setReq_time(System.currentTimeMillis()).setReq_data(reqData));
        HttpPost post = new HttpPost(URL);
        post.addHeader("Content-Type", "application/json");
        post.addHeader("ACCT_ID", API_ID);
        post.setEntity((HttpEntity)new StringEntity(YushanAES.encode(reqJson, API_KEY), StandardCharsets.UTF_8));
        log.info("[{}]identify reqId:{}  reqJson:{}", new Object[]{identifyProduct, requestId, reqJson});
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int status = response.getStatusLine().getStatusCode();
            String encodedResult = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (status != HttpStatus.OK.value() || StringUtils.isEmpty((String)encodedResult)) {
                log.error("identify error {} - {} - {}", new Object[]{status, encodedResult, ""});
                throw new IllegalStateException("\u7cfb\u7edf\u67e5\u8be2\u5931\u8d25(sc_not_ok)");
            }
            String resJson = YushanAES.decode(encodedResult, API_KEY);
            log.info("[{}] - resJson {}", (Object)requestId, (Object)resJson);
            IdentifyCommonRes res = (IdentifyCommonRes)JSON.parseObject((String)resJson, resClazz);
            if (Objects.isNull(res)) {
                throw new IllegalStateException("\u7cfb\u7edf\u67e5\u8be2\u5931\u8d25(res_is_null)");
            }
            if (res.noSuchInfo()) {
                throw new IllegalStateException("\u672a\u67e5\u8be2\u5230\u4fe1\u606f");
            }
            if (!res.success()) {
                throw new IllegalStateException("\u7cfb\u7edf\u67e5\u8be2\u5931\u8d25(res_not_suc)");
            }
            IdentifyCommonRes identifyCommonRes = res;
            return (T)identifyCommonRes;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u67e5\u8be2\u5931\u8d25");
        }
        finally {
            post.releaseConnection();
        }
    }

    public static class CarData {
        private Integer carNum;

        public Integer getCarNum() {
            return this.carNum;
        }

        public void setCarNum(Integer carNum) {
            this.carNum = carNum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CarData)) {
                return false;
            }
            CarData other = (CarData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$carNum = this.getCarNum();
            Integer other$carNum = other.getCarNum();
            return !(this$carNum == null ? other$carNum != null : !((Object)this$carNum).equals(other$carNum));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CarData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $carNum = this.getCarNum();
            result = result * 59 + ($carNum == null ? 43 : ((Object)$carNum).hashCode());
            return result;
        }

        public String toString() {
            return "IdentifyIntegration.CarData(carNum=" + this.getCarNum() + ")";
        }
    }

    public static class EducationData {
        private String admissionDate;
        private String graduationDate;
        private String major;
        private String educationType;
        private String educationLevel;
        private String schoolType;
        private String isDoubleFirstClass;
        private String isProject211;
        private String isProject985;
        private String Ranking;

        public String getAdmissionDate() {
            return this.admissionDate;
        }

        public String getGraduationDate() {
            return this.graduationDate;
        }

        public String getMajor() {
            return this.major;
        }

        public String getEducationType() {
            return this.educationType;
        }

        public String getEducationLevel() {
            return this.educationLevel;
        }

        public String getSchoolType() {
            return this.schoolType;
        }

        public String getIsDoubleFirstClass() {
            return this.isDoubleFirstClass;
        }

        public String getIsProject211() {
            return this.isProject211;
        }

        public String getIsProject985() {
            return this.isProject985;
        }

        public String getRanking() {
            return this.Ranking;
        }

        public void setAdmissionDate(String admissionDate) {
            this.admissionDate = admissionDate;
        }

        public void setGraduationDate(String graduationDate) {
            this.graduationDate = graduationDate;
        }

        public void setMajor(String major) {
            this.major = major;
        }

        public void setEducationType(String educationType) {
            this.educationType = educationType;
        }

        public void setEducationLevel(String educationLevel) {
            this.educationLevel = educationLevel;
        }

        public void setSchoolType(String schoolType) {
            this.schoolType = schoolType;
        }

        public void setIsDoubleFirstClass(String isDoubleFirstClass) {
            this.isDoubleFirstClass = isDoubleFirstClass;
        }

        public void setIsProject211(String isProject211) {
            this.isProject211 = isProject211;
        }

        public void setIsProject985(String isProject985) {
            this.isProject985 = isProject985;
        }

        public void setRanking(String Ranking) {
            this.Ranking = Ranking;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EducationData)) {
                return false;
            }
            EducationData other = (EducationData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$admissionDate = this.getAdmissionDate();
            String other$admissionDate = other.getAdmissionDate();
            if (this$admissionDate == null ? other$admissionDate != null : !this$admissionDate.equals(other$admissionDate)) {
                return false;
            }
            String this$graduationDate = this.getGraduationDate();
            String other$graduationDate = other.getGraduationDate();
            if (this$graduationDate == null ? other$graduationDate != null : !this$graduationDate.equals(other$graduationDate)) {
                return false;
            }
            String this$major = this.getMajor();
            String other$major = other.getMajor();
            if (this$major == null ? other$major != null : !this$major.equals(other$major)) {
                return false;
            }
            String this$educationType = this.getEducationType();
            String other$educationType = other.getEducationType();
            if (this$educationType == null ? other$educationType != null : !this$educationType.equals(other$educationType)) {
                return false;
            }
            String this$educationLevel = this.getEducationLevel();
            String other$educationLevel = other.getEducationLevel();
            if (this$educationLevel == null ? other$educationLevel != null : !this$educationLevel.equals(other$educationLevel)) {
                return false;
            }
            String this$schoolType = this.getSchoolType();
            String other$schoolType = other.getSchoolType();
            if (this$schoolType == null ? other$schoolType != null : !this$schoolType.equals(other$schoolType)) {
                return false;
            }
            String this$isDoubleFirstClass = this.getIsDoubleFirstClass();
            String other$isDoubleFirstClass = other.getIsDoubleFirstClass();
            if (this$isDoubleFirstClass == null ? other$isDoubleFirstClass != null : !this$isDoubleFirstClass.equals(other$isDoubleFirstClass)) {
                return false;
            }
            String this$isProject211 = this.getIsProject211();
            String other$isProject211 = other.getIsProject211();
            if (this$isProject211 == null ? other$isProject211 != null : !this$isProject211.equals(other$isProject211)) {
                return false;
            }
            String this$isProject985 = this.getIsProject985();
            String other$isProject985 = other.getIsProject985();
            if (this$isProject985 == null ? other$isProject985 != null : !this$isProject985.equals(other$isProject985)) {
                return false;
            }
            String this$Ranking = this.getRanking();
            String other$Ranking = other.getRanking();
            return !(this$Ranking == null ? other$Ranking != null : !this$Ranking.equals(other$Ranking));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EducationData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $admissionDate = this.getAdmissionDate();
            result = result * 59 + ($admissionDate == null ? 43 : $admissionDate.hashCode());
            String $graduationDate = this.getGraduationDate();
            result = result * 59 + ($graduationDate == null ? 43 : $graduationDate.hashCode());
            String $major = this.getMajor();
            result = result * 59 + ($major == null ? 43 : $major.hashCode());
            String $educationType = this.getEducationType();
            result = result * 59 + ($educationType == null ? 43 : $educationType.hashCode());
            String $educationLevel = this.getEducationLevel();
            result = result * 59 + ($educationLevel == null ? 43 : $educationLevel.hashCode());
            String $schoolType = this.getSchoolType();
            result = result * 59 + ($schoolType == null ? 43 : $schoolType.hashCode());
            String $isDoubleFirstClass = this.getIsDoubleFirstClass();
            result = result * 59 + ($isDoubleFirstClass == null ? 43 : $isDoubleFirstClass.hashCode());
            String $isProject211 = this.getIsProject211();
            result = result * 59 + ($isProject211 == null ? 43 : $isProject211.hashCode());
            String $isProject985 = this.getIsProject985();
            result = result * 59 + ($isProject985 == null ? 43 : $isProject985.hashCode());
            String $Ranking = this.getRanking();
            result = result * 59 + ($Ranking == null ? 43 : $Ranking.hashCode());
            return result;
        }

        public String toString() {
            return "IdentifyIntegration.EducationData(admissionDate=" + this.getAdmissionDate() + ", graduationDate=" + this.getGraduationDate() + ", major=" + this.getMajor() + ", educationType=" + this.getEducationType() + ", educationLevel=" + this.getEducationLevel() + ", schoolType=" + this.getSchoolType() + ", isDoubleFirstClass=" + this.getIsDoubleFirstClass() + ", isProject211=" + this.getIsProject211() + ", isProject985=" + this.getIsProject985() + ", Ranking=" + this.getRanking() + ")";
        }
    }

    public static class MarriageData {
        private Integer status;

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarriageData)) {
                return false;
            }
            MarriageData other = (MarriageData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !((Object)this$status).equals(other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MarriageData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            return result;
        }

        public String toString() {
            return "IdentifyIntegration.MarriageData(status=" + this.getStatus() + ")";
        }
    }

    private static class IdentifyCommonRes<T> {
        private String request_sn;
        private String response_sn;
        private T retdata;
        private String retcode;
        private String retmsg;
        private Long retdate;

        public boolean success() {
            return Objects.equals("000000", this.retcode);
        }

        public boolean noSuchInfo() {
            return Objects.equals("100000", this.retcode);
        }

        public String getRequest_sn() {
            return this.request_sn;
        }

        public String getResponse_sn() {
            return this.response_sn;
        }

        public T getRetdata() {
            return this.retdata;
        }

        public String getRetcode() {
            return this.retcode;
        }

        public String getRetmsg() {
            return this.retmsg;
        }

        public Long getRetdate() {
            return this.retdate;
        }

        public void setRequest_sn(String request_sn) {
            this.request_sn = request_sn;
        }

        public void setResponse_sn(String response_sn) {
            this.response_sn = response_sn;
        }

        public void setRetdata(T retdata) {
            this.retdata = retdata;
        }

        public void setRetcode(String retcode) {
            this.retcode = retcode;
        }

        public void setRetmsg(String retmsg) {
            this.retmsg = retmsg;
        }

        public void setRetdate(Long retdate) {
            this.retdate = retdate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdentifyCommonRes)) {
                return false;
            }
            IdentifyCommonRes other = (IdentifyCommonRes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$retdate = this.getRetdate();
            Long other$retdate = other.getRetdate();
            if (this$retdate == null ? other$retdate != null : !((Object)this$retdate).equals(other$retdate)) {
                return false;
            }
            String this$request_sn = this.getRequest_sn();
            String other$request_sn = other.getRequest_sn();
            if (this$request_sn == null ? other$request_sn != null : !this$request_sn.equals(other$request_sn)) {
                return false;
            }
            String this$response_sn = this.getResponse_sn();
            String other$response_sn = other.getResponse_sn();
            if (this$response_sn == null ? other$response_sn != null : !this$response_sn.equals(other$response_sn)) {
                return false;
            }
            T this$retdata = this.getRetdata();
            T other$retdata = other.getRetdata();
            if (this$retdata == null ? other$retdata != null : !this$retdata.equals(other$retdata)) {
                return false;
            }
            String this$retcode = this.getRetcode();
            String other$retcode = other.getRetcode();
            if (this$retcode == null ? other$retcode != null : !this$retcode.equals(other$retcode)) {
                return false;
            }
            String this$retmsg = this.getRetmsg();
            String other$retmsg = other.getRetmsg();
            return !(this$retmsg == null ? other$retmsg != null : !this$retmsg.equals(other$retmsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdentifyCommonRes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $retdate = this.getRetdate();
            result = result * 59 + ($retdate == null ? 43 : ((Object)$retdate).hashCode());
            String $request_sn = this.getRequest_sn();
            result = result * 59 + ($request_sn == null ? 43 : $request_sn.hashCode());
            String $response_sn = this.getResponse_sn();
            result = result * 59 + ($response_sn == null ? 43 : $response_sn.hashCode());
            T $retdata = this.getRetdata();
            result = result * 59 + ($retdata == null ? 43 : $retdata.hashCode());
            String $retcode = this.getRetcode();
            result = result * 59 + ($retcode == null ? 43 : $retcode.hashCode());
            String $retmsg = this.getRetmsg();
            result = result * 59 + ($retmsg == null ? 43 : $retmsg.hashCode());
            return result;
        }

        public String toString() {
            return "IdentifyIntegration.IdentifyCommonRes(request_sn=" + this.getRequest_sn() + ", response_sn=" + this.getResponse_sn() + ", retdata=" + this.getRetdata() + ", retcode=" + this.getRetcode() + ", retmsg=" + this.getRetmsg() + ", retdate=" + this.getRetdate() + ")";
        }
    }

    private static class CarRes
    extends IdentifyCommonRes<CarData> {
        private CarRes() {
        }
    }

    private static class EducationRes
    extends IdentifyCommonRes<List<EducationData>> {
        private EducationRes() {
        }
    }

    private static class MarriageRes
    extends IdentifyCommonRes<MarriageData> {
        private MarriageRes() {
        }
    }

    private static class ReqData {
        private String name;
        private String cardNo;

        public String getName() {
            return this.name;
        }

        public String getCardNo() {
            return this.cardNo;
        }

        public ReqData setName(String name) {
            this.name = name;
            return this;
        }

        public ReqData setCardNo(String cardNo) {
            this.cardNo = cardNo;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReqData)) {
                return false;
            }
            ReqData other = (ReqData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$cardNo = this.getCardNo();
            String other$cardNo = other.getCardNo();
            return !(this$cardNo == null ? other$cardNo != null : !this$cardNo.equals(other$cardNo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReqData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $cardNo = this.getCardNo();
            result = result * 59 + ($cardNo == null ? 43 : $cardNo.hashCode());
            return result;
        }

        public String toString() {
            return "IdentifyIntegration.ReqData(name=" + this.getName() + ", cardNo=" + this.getCardNo() + ")";
        }
    }

    private static class IdentifyRequest {
        private String request_sn;
        private String acct_id;
        private String prod_id;
        private Long req_time;
        private ReqData req_data;

        public String getRequest_sn() {
            return this.request_sn;
        }

        public String getAcct_id() {
            return this.acct_id;
        }

        public String getProd_id() {
            return this.prod_id;
        }

        public Long getReq_time() {
            return this.req_time;
        }

        public ReqData getReq_data() {
            return this.req_data;
        }

        public IdentifyRequest setRequest_sn(String request_sn) {
            this.request_sn = request_sn;
            return this;
        }

        public IdentifyRequest setAcct_id(String acct_id) {
            this.acct_id = acct_id;
            return this;
        }

        public IdentifyRequest setProd_id(String prod_id) {
            this.prod_id = prod_id;
            return this;
        }

        public IdentifyRequest setReq_time(Long req_time) {
            this.req_time = req_time;
            return this;
        }

        public IdentifyRequest setReq_data(ReqData req_data) {
            this.req_data = req_data;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdentifyRequest)) {
                return false;
            }
            IdentifyRequest other = (IdentifyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$req_time = this.getReq_time();
            Long other$req_time = other.getReq_time();
            if (this$req_time == null ? other$req_time != null : !((Object)this$req_time).equals(other$req_time)) {
                return false;
            }
            String this$request_sn = this.getRequest_sn();
            String other$request_sn = other.getRequest_sn();
            if (this$request_sn == null ? other$request_sn != null : !this$request_sn.equals(other$request_sn)) {
                return false;
            }
            String this$acct_id = this.getAcct_id();
            String other$acct_id = other.getAcct_id();
            if (this$acct_id == null ? other$acct_id != null : !this$acct_id.equals(other$acct_id)) {
                return false;
            }
            String this$prod_id = this.getProd_id();
            String other$prod_id = other.getProd_id();
            if (this$prod_id == null ? other$prod_id != null : !this$prod_id.equals(other$prod_id)) {
                return false;
            }
            ReqData this$req_data = this.getReq_data();
            ReqData other$req_data = other.getReq_data();
            return !(this$req_data == null ? other$req_data != null : !((Object)this$req_data).equals(other$req_data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdentifyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $req_time = this.getReq_time();
            result = result * 59 + ($req_time == null ? 43 : ((Object)$req_time).hashCode());
            String $request_sn = this.getRequest_sn();
            result = result * 59 + ($request_sn == null ? 43 : $request_sn.hashCode());
            String $acct_id = this.getAcct_id();
            result = result * 59 + ($acct_id == null ? 43 : $acct_id.hashCode());
            String $prod_id = this.getProd_id();
            result = result * 59 + ($prod_id == null ? 43 : $prod_id.hashCode());
            ReqData $req_data = this.getReq_data();
            result = result * 59 + ($req_data == null ? 43 : ((Object)$req_data).hashCode());
            return result;
        }

        public String toString() {
            return "IdentifyIntegration.IdentifyRequest(request_sn=" + this.getRequest_sn() + ", acct_id=" + this.getAcct_id() + ", prod_id=" + this.getProd_id() + ", req_time=" + this.getReq_time() + ", req_data=" + this.getReq_data() + ")";
        }
    }
}

