/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.integration.pay;

import com.bxm.lovelink.integration.pay.facade.PayOrder;
import com.bxm.lovelink.integration.pay.facade.PayService;
import com.bxm.lovelink.integration.pay.facade.RefundResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;

@EnableFeignClients(value={"com.bxm.lovelink.integration.pay.facade"})
@Component
public class PayIntegration {
    private static final Logger log = LoggerFactory.getLogger(PayIntegration.class);
    private final PayService payService;

    public PayIntegration(PayService payService) {
        this.payService = payService;
    }

    public String pay(PayOrder payOrder) {
        return this.payService.pay(payOrder);
    }

    public void refund(PayOrder payOrder) {
        RefundResult refund = this.payService.refund(payOrder);
        if (!refund.isSuccess()) {
            log.error("refund msg {}", (Object)refund.getMsg());
            throw new RuntimeException("\u8bf7\u6c42\u9000\u6b3e\u5931\u8d25");
        }
    }

    public void close(PayOrder payOrder) {
        this.payService.close(payOrder);
    }
}

