/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.integration.recommend;

import com.bxm.lovelink.rs.facade.RecommendItem;
import com.bxm.lovelink.rs.facade.RecommendRequest;
import com.bxm.lovelink.rs.facade.RecommendResponse;
import com.bxm.lovelink.rs.facade.RecommendServiceFacade;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@EnableFeignClients(value={"com.bxm.lovelink.rs.facade"})
public class RecommendIntegration {
    private static final Logger log = LoggerFactory.getLogger(RecommendIntegration.class);
    private final RecommendServiceFacade recommendService;

    public RecommendIntegration(RecommendServiceFacade recommendService) {
        this.recommendService = recommendService;
    }

    public RecommendResponse recommend(RecommendRequest recommendRequest) {
        log.info("recommend request:{}", (Object)JsonHelper.convert((Object)recommendRequest));
        RecommendResponse recommendResponse = (RecommendResponse)this.recommendService.list(recommendRequest).getBody();
        ArrayList userIdList = Lists.newArrayList();
        if (Objects.nonNull(recommendResponse) && !CollectionUtils.isEmpty((Collection)recommendResponse.getRecommendList())) {
            recommendResponse.getRecommendList().stream().filter(Objects::nonNull).map(RecommendItem::getId).forEach(userIdList::add);
        }
        log.info("recommend requestId:{}, responseUserIdList:{}", (Object)recommendRequest.getRequestId(), (Object)userIdList);
        return recommendResponse;
    }
}

