/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.integration.robot;

import com.bxm.warcar.utils.HttpClientHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class RobotIntegration {
    private static final Logger log = LoggerFactory.getLogger(RobotIntegration.class);
    private static final String URL = "https://api.flowbot.xlrpa.com/api/sendTask?robotId=";
    private final HttpClient httpClient = HttpClientHelper.createHttpClient((int)10, (int)10, (int)15000, (int)15000, (int)15000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBotMsg(String searchText, String msg, String robotId) {
        if (StringUtils.isBlank((String)msg)) {
            return;
        }
        SendRequest sendRequest = new SendRequest().setTaskList(Lists.newArrayList((Object[])new SendRequest.TaskItem[]{new SendRequest.TaskItem().setMessage(msg).setSearchText(searchText)}));
        HttpPost post = new HttpPost(URL + robotId);
        post.addHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)sendRequest), StandardCharsets.UTF_8));
        try {
            SendResponse sendResponse;
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int status = response.getStatusLine().getStatusCode();
            String entity = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            log.info("\u4f01\u5fae\u673a\u5668\u4eba\u53d1\u9001\u6d88\u606f\u7ed3\u679c\uff1a{}  - req: {}", (Object)entity, (Object)JsonHelper.convert((Object)sendRequest));
            if (status != HttpStatus.OK.value() || StringUtils.isEmpty((String)entity)) {
                log.error("sendBotMsg error {} - {}", (Object)status, (Object)entity);
            }
            if (!(sendResponse = (SendResponse)JsonHelper.convert((String)entity, SendResponse.class)).success()) {
                log.error("sendBotMsg fail {}", (Object)entity);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
    }

    public static class SendResponse {
        private int code;
        private String message;

        public boolean success() {
            return this.code == 200;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendResponse)) {
                return false;
            }
            SendResponse other = (SendResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "RobotIntegration.SendResponse(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
        }
    }

    public static class SendRequest {
        private List<TaskItem> taskList;

        public List<TaskItem> getTaskList() {
            return this.taskList;
        }

        public SendRequest setTaskList(List<TaskItem> taskList) {
            this.taskList = taskList;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendRequest)) {
                return false;
            }
            SendRequest other = (SendRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<TaskItem> this$taskList = this.getTaskList();
            List<TaskItem> other$taskList = other.getTaskList();
            return !(this$taskList == null ? other$taskList != null : !((Object)this$taskList).equals(other$taskList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<TaskItem> $taskList = this.getTaskList();
            result = result * 59 + ($taskList == null ? 43 : ((Object)$taskList).hashCode());
            return result;
        }

        public String toString() {
            return "RobotIntegration.SendRequest(taskList=" + this.getTaskList() + ")";
        }

        public static class TaskItem {
            private Integer type = 10001;
            private String searchText;
            private String message;

            public Integer getType() {
                return this.type;
            }

            public String getSearchText() {
                return this.searchText;
            }

            public String getMessage() {
                return this.message;
            }

            public TaskItem setType(Integer type) {
                this.type = type;
                return this;
            }

            public TaskItem setSearchText(String searchText) {
                this.searchText = searchText;
                return this;
            }

            public TaskItem setMessage(String message) {
                this.message = message;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaskItem)) {
                    return false;
                }
                TaskItem other = (TaskItem)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$type = this.getType();
                Integer other$type = other.getType();
                if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                    return false;
                }
                String this$searchText = this.getSearchText();
                String other$searchText = other.getSearchText();
                if (this$searchText == null ? other$searchText != null : !this$searchText.equals(other$searchText)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            protected boolean canEqual(Object other) {
                return other instanceof TaskItem;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $type = this.getType();
                result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
                String $searchText = this.getSearchText();
                result = result * 59 + ($searchText == null ? 43 : $searchText.hashCode());
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }

            public String toString() {
                return "RobotIntegration.SendRequest.TaskItem(type=" + this.getType() + ", searchText=" + this.getSearchText() + ", message=" + this.getMessage() + ")";
            }
        }
    }
}

