/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.message;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="lovelink.message.mqtt")
public class MqttProperties {
    private String instanceId = "";
    private String endpoint = "";
    private int cloudPort = 5672;
    private String accessKey = "";
    private String secretKey = "";
    private String clientIdPrefixForDevice = "GID_lovelink_client@@@";
    private String topicOfServer = "lovelink-server-topic";
    private String p2pTopicOfDevice = "lovelink-client-topic";

    public String getServerUrl() {
        return "ssl://" + this.endpoint + ":8883";
    }

    public String createClientId(String id) {
        return String.format("%s%s", this.clientIdPrefixForDevice, id);
    }

    public String createP2pTopic(String clientId) {
        return String.format("%s/p2p/%s", this.p2pTopicOfDevice, clientId);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public int getCloudPort() {
        return this.cloudPort;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getClientIdPrefixForDevice() {
        return this.clientIdPrefixForDevice;
    }

    public String getTopicOfServer() {
        return this.topicOfServer;
    }

    public String getP2pTopicOfDevice() {
        return this.p2pTopicOfDevice;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setCloudPort(int cloudPort) {
        this.cloudPort = cloudPort;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setClientIdPrefixForDevice(String clientIdPrefixForDevice) {
        this.clientIdPrefixForDevice = clientIdPrefixForDevice;
    }

    public void setTopicOfServer(String topicOfServer) {
        this.topicOfServer = topicOfServer;
    }

    public void setP2pTopicOfDevice(String p2pTopicOfDevice) {
        this.p2pTopicOfDevice = p2pTopicOfDevice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttProperties)) {
            return false;
        }
        MqttProperties other = (MqttProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCloudPort() != other.getCloudPort()) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$clientIdPrefixForDevice = this.getClientIdPrefixForDevice();
        String other$clientIdPrefixForDevice = other.getClientIdPrefixForDevice();
        if (this$clientIdPrefixForDevice == null ? other$clientIdPrefixForDevice != null : !this$clientIdPrefixForDevice.equals(other$clientIdPrefixForDevice)) {
            return false;
        }
        String this$topicOfServer = this.getTopicOfServer();
        String other$topicOfServer = other.getTopicOfServer();
        if (this$topicOfServer == null ? other$topicOfServer != null : !this$topicOfServer.equals(other$topicOfServer)) {
            return false;
        }
        String this$p2pTopicOfDevice = this.getP2pTopicOfDevice();
        String other$p2pTopicOfDevice = other.getP2pTopicOfDevice();
        return !(this$p2pTopicOfDevice == null ? other$p2pTopicOfDevice != null : !this$p2pTopicOfDevice.equals(other$p2pTopicOfDevice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqttProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCloudPort();
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $clientIdPrefixForDevice = this.getClientIdPrefixForDevice();
        result = result * 59 + ($clientIdPrefixForDevice == null ? 43 : $clientIdPrefixForDevice.hashCode());
        String $topicOfServer = this.getTopicOfServer();
        result = result * 59 + ($topicOfServer == null ? 43 : $topicOfServer.hashCode());
        String $p2pTopicOfDevice = this.getP2pTopicOfDevice();
        result = result * 59 + ($p2pTopicOfDevice == null ? 43 : $p2pTopicOfDevice.hashCode());
        return result;
    }

    public String toString() {
        return "MqttProperties(instanceId=" + this.getInstanceId() + ", endpoint=" + this.getEndpoint() + ", cloudPort=" + this.getCloudPort() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", clientIdPrefixForDevice=" + this.getClientIdPrefixForDevice() + ", topicOfServer=" + this.getTopicOfServer() + ", p2pTopicOfDevice=" + this.getP2pTopicOfDevice() + ")";
    }
}

