/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.message.ali;

import com.alibaba.mqtt.server.ServerConsumer;
import com.alibaba.mqtt.server.callback.MessageListener;
import com.alibaba.mqtt.server.config.ChannelConfig;
import com.alibaba.mqtt.server.config.ConsumerConfig;
import com.bxm.lovelink.message.MqttProperties;
import com.bxm.lovelink.message.ali.AliMqttCloudConsumerMessageListener;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliMqttCloudConsumer {
    private static final Logger log = LoggerFactory.getLogger(AliMqttCloudConsumer.class);
    private final MqttProperties mqttProperties;
    private final ServerConsumer serverConsumer;
    private final AliMqttCloudConsumerMessageListener aliMqttCloudConsumerMessageListener;

    public AliMqttCloudConsumer(MqttProperties mqttProperties, AliMqttCloudConsumerMessageListener aliMqttCloudConsumerMessageListener) {
        this.mqttProperties = mqttProperties;
        this.aliMqttCloudConsumerMessageListener = aliMqttCloudConsumerMessageListener;
        String domain = mqttProperties.getEndpoint();
        int port = mqttProperties.getCloudPort();
        String instanceId = mqttProperties.getInstanceId();
        String accessKey = mqttProperties.getAccessKey();
        String secretKey = mqttProperties.getSecretKey();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.setDomain(domain);
        channelConfig.setPort(port);
        channelConfig.setInstanceId(instanceId);
        channelConfig.setAccessKey(accessKey);
        channelConfig.setSecretKey(secretKey);
        this.serverConsumer = new ServerConsumer(channelConfig, new ConsumerConfig());
    }

    @PostConstruct
    public void init() {
        try {
            this.serverConsumer.start();
            this.serverConsumer.subscribeTopic(this.mqttProperties.getTopicOfServer(), (MessageListener)this.aliMqttCloudConsumerMessageListener);
            log.info("MQTT cloud consumer started");
        }
        catch (IOException | TimeoutException e) {
            log.error("Failed to start MQTT cloud consumer", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void destroy() {
        try {
            this.serverConsumer.stop();
            log.info("MQTT cloud consumer stopped");
        }
        catch (IOException e) {
            log.error("Failed to stop MQTT cloud consumer", (Throwable)e);
        }
    }
}

