/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.message.ali;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.mqtt.server.callback.MessageListener;
import com.alibaba.mqtt.server.model.MessageProperties;
import com.bxm.lovelink.message.entity.MqttMsg;
import com.bxm.lovelink.message.factory.UpMqttMsgHandler;
import com.bxm.lovelink.message.factory.UpMqttMsgHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliMqttCloudConsumerMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(AliMqttCloudConsumerMessageListener.class);
    private final UpMqttMsgHandlerFactory upMqttMsgHandlerFactory;

    public AliMqttCloudConsumerMessageListener(UpMqttMsgHandlerFactory upMqttMsgHandlerFactory) {
        this.upMqttMsgHandlerFactory = upMqttMsgHandlerFactory;
    }

    public void process(String msgId, MessageProperties messageProperties, byte[] payload) {
        String json = new String(payload);
        String firstTopic = messageProperties.getFirstTopic();
        String secondTopic = messageProperties.getSecondTopic();
        String clientId = messageProperties.getClientId();
        try {
            log.info("[{}/{}] Receive message: {} from: {}", new Object[]{firstTopic, secondTopic, json, clientId});
            MqttMsg mqttMsg = (MqttMsg)JSONObject.parseObject((String)json, (TypeReference)new TypeReference<MqttMsg<String>>(){}, (Feature[])new Feature[0]);
            UpMqttMsgHandler handler = this.upMqttMsgHandlerFactory.getHandler(mqttMsg.ofType());
            if (null == handler) {
                throw new NullPointerException("Unsupported: " + mqttMsg.getType());
            }
            handler.handle(mqttMsg.getMessage(), (String)mqttMsg.getBody());
        }
        catch (Exception e) {
            log.error("Receive message error: {}", (Object)e.getMessage());
        }
    }
}

