/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.message.ali;

import com.alibaba.mqtt.server.ServerProducer;
import com.alibaba.mqtt.server.callback.SendCallback;
import com.alibaba.mqtt.server.common.SendResult;
import com.alibaba.mqtt.server.config.ChannelConfig;
import com.alibaba.mqtt.server.config.ProducerConfig;
import com.bxm.lovelink.message.MqttProperties;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliMqttCloudProducer {
    private static final Logger log = LoggerFactory.getLogger(AliMqttCloudProducer.class);
    private final ServerProducer serverProducer;

    public AliMqttCloudProducer(MqttProperties mqttProperties) {
        String domain = mqttProperties.getEndpoint();
        int port = mqttProperties.getCloudPort();
        String instanceId = mqttProperties.getInstanceId();
        String accessKey = mqttProperties.getAccessKey();
        String secretKey = mqttProperties.getSecretKey();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.setDomain(domain);
        channelConfig.setPort(port);
        channelConfig.setInstanceId(instanceId);
        channelConfig.setAccessKey(accessKey);
        channelConfig.setSecretKey(secretKey);
        this.serverProducer = new ServerProducer(channelConfig, new ProducerConfig());
    }

    public void sendMessageQuiet(String topic, byte[] payload) {
        try {
            this.serverProducer.sendMessage(topic, payload);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SendResult sendMessage(String topic, byte[] payload) throws IOException {
        return this.serverProducer.sendMessage(topic, payload);
    }

    public void sendMessage(String topic, byte[] payload, SendCallback sendCallback) {
        try {
            this.serverProducer.sendMessage(topic, payload, sendCallback);
        }
        catch (IOException e) {
            log.error("Failed to send message", (Throwable)e);
            sendCallback.onFail();
        }
    }

    @PostConstruct
    public void init() {
        try {
            this.serverProducer.start();
            String domain = this.serverProducer.getChannelConfig().getDomain();
            log.info("MQTT cloud endpoint {} producer started!", (Object)domain);
        }
        catch (IOException | TimeoutException e) {
            log.error("Failed to start MQTT cloud consumer", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void destroy() {
        try {
            this.serverProducer.stop();
            log.info("MQTT cloud producer stopped");
        }
        catch (IOException e) {
            log.error("Failed to stop MQTT cloud consumer", (Throwable)e);
        }
    }
}

