/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.message.ali;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.mqtt.server.common.SendResult;
import com.bxm.lovelink.message.MqttProperties;
import com.bxm.lovelink.message.MqttService;
import com.bxm.lovelink.message.ali.AliMqttCloudProducer;
import com.bxm.lovelink.message.ali.Tools;
import com.bxm.lovelink.message.entity.MqttAuth;
import com.bxm.lovelink.message.entity.MqttMsg;
import com.bxm.lovelink.message.entity.MqttMsgSendResult;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class AliMqttServiceImpl
implements MqttService {
    private static final Logger log = LoggerFactory.getLogger(AliMqttServiceImpl.class);
    private final MqttProperties mqttProperties;
    private final AliMqttCloudProducer aliMqttCloudProducer;

    public AliMqttServiceImpl(MqttProperties mqttProperties, AliMqttCloudProducer aliMqttCloudProducer) {
        this.mqttProperties = mqttProperties;
        this.aliMqttCloudProducer = aliMqttCloudProducer;
    }

    @Override
    public MqttAuth createMqttAuth(Long userId) {
        String clientId = this.mqttProperties.createClientId(Objects.toString(userId));
        return this.createMqttAuth(clientId);
    }

    @Override
    public MqttAuth createMqttAuth(String clientId) {
        try {
            return MqttAuth.builder().endpoint(this.mqttProperties.getEndpoint()).serverUrl(this.mqttProperties.getServerUrl()).clientId(clientId).username("Signature|" + this.mqttProperties.getAccessKey() + "|" + this.mqttProperties.getInstanceId()).password(Tools.macSignature(clientId, this.mqttProperties.getSecretKey())).publishTopic(this.mqttProperties.getTopicOfServer()).build();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("\u3010ali-mqtt\u3011\u521b\u5efamqtt\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff0cclientId:{}", (Object)clientId, (Object)e);
            return null;
        }
    }

    @Override
    public String createP2pTopic(Long userId) {
        Assert.notNull((Object)userId, (String)"userId\u4e0d\u80fd\u4e3a\u7a7a");
        String clientId = this.mqttProperties.createClientId(Objects.toString(userId));
        return this.createP2pTopic(clientId);
    }

    @Override
    public String createP2pTopic(String clientId) {
        return this.mqttProperties.createP2pTopic(clientId);
    }

    @Override
    public void sendMessageQuiet(Long userId, MqttMsg<?> mqttMsg) {
        String p2pTopic = this.createP2pTopic(userId);
        this.sendMessageQuiet(p2pTopic, mqttMsg);
    }

    @Override
    public void sendMessageQuiet(String topic, MqttMsg<?> mqttMsg) {
        this.aliMqttCloudProducer.sendMessageQuiet(topic, JSONObject.toJSONBytes(mqttMsg, (SerializerFeature[])new SerializerFeature[0]));
        log.info("\u3010MQTT\u3011\u53d1\u9001\u6d88\u606f\u6210\u529f\uff0ctopic:{}, mqttMsg:{}", (Object)topic, mqttMsg);
    }

    @Override
    public MqttMsgSendResult sendMessage(String topic, MqttMsg<?> mqttMsg) {
        try {
            SendResult sendResult = this.aliMqttCloudProducer.sendMessage(topic, JSONObject.toJSONBytes(mqttMsg, (SerializerFeature[])new SerializerFeature[0]));
            return new MqttMsgSendResult().setMsgId(sendResult.getMsgId()).setSuccess(sendResult.isSuccess());
        }
        catch (IOException e) {
            log.error("Failed to send message: {} - {}", new Object[]{topic, mqttMsg, e});
            return new MqttMsgSendResult().setSuccess(false);
        }
    }
}

