/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.message.factory;

import com.bxm.lovelink.message.entity.MqttMsgType;
import com.bxm.lovelink.message.factory.UpMqttMsgHandler;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class UpMqttMsgHandlerFactory {
    private final Map<MqttMsgType, UpMqttMsgHandler> map;

    public UpMqttMsgHandlerFactory(Collection<UpMqttMsgHandler> upMqttMsgHandlers) {
        this.map = upMqttMsgHandlers.stream().collect(Collectors.toMap(UpMqttMsgHandler::of, upMqttMsgHandler -> upMqttMsgHandler));
    }

    public UpMqttMsgHandler getHandler(MqttMsgType mqttMsgType) {
        if (null == mqttMsgType) {
            return null;
        }
        UpMqttMsgHandler upMqttMsgHandler = this.map.get((Object)mqttMsgType);
        if (upMqttMsgHandler == null) {
            throw new IllegalStateException("\u6d88\u606f\u7c7b\u578b\u4e0d\u652f\u6301\uff1a" + (Object)((Object)mqttMsgType));
        }
        return upMqttMsgHandler;
    }

    public void handle(String message, String body) {
        MqttMsgType mqttMsgType = MqttMsgType.getByType(message);
        UpMqttMsgHandler upMqttMsgHandler = this.getHandler(mqttMsgType);
        upMqttMsgHandler.handle(message, body);
    }
}

