package com.bxm.lovelink.rs.facade;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.Set;

/**
 * @author Allen Hu
 * @date 2025/6/23
 */
@Data
public class RecommendRequest {

    /**
     * 请求ID
     */
    private String requestId;

    /**
     * 当前请求的用户
     */
    @Valid
    @NotNull
    private User user;

    /**
     * 是否为调试模式，仅 recommendType=DEFAULT 时有效
     */
    private boolean debug;

    /**
     * 返回的结果是否包含用户更多信息，仅 recommendType=DEFAULT 时有效
     */
    private boolean containUserInfo;

    /**
     * 指定排除的用户编号
     */
    private Set<String> excludeUserNumbers;

    /**
     * 推荐引擎实现类型，指定则走指定的实现，否则走AB分流
     */
    private RecommendType recommendType;
}
