package com.bxm.lovelink.rs.facade;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

/**
 * @author Allen Hu
 * @date 2025/6/23
 */
@Data
@Builder
@Accessors(chain = true)
public class RecommendResponse {

    /**
     * 请求ID
     */
    private String requestId;

    /**
     * 推荐结果集
     */
    private List<RecommendItem> recommendList;

    /**
     * 推荐日志
     */
    private Map<String, List<Object>> logging;

    /**
     * 本次推荐执行器的类型
     */
    private RecommendType recommendType;
}
