package com.bxm.lovelink.rs.facade;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;

/**
 * @author Allen Hu
 * @date 2025/6/23
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class User {

    /**
     * user_id
     */
    @NotNull
    private Long id;
    /**
     * 1 男 0 女
     */
    @NotNull
    private Integer gender;
    /**
     * 生日
     */
    @NotNull
    private LocalDate birthday;
    /**
     * 身高 cm
     */
    private Integer height;
    /**
     * 工作
     */
    private String job;
    /**
     * 现居地 区code
     */
    private Integer currentPlaceDistrict;
    /**
     * 学历  2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    @NotNull
    private Integer eduHighest;
    /**
     * 年收入 2、五万以下，4、5-10万，8、10-20万，16、20-30万，32、30-40万，64、40-50万，128、50-100万，256、100万以上
     */
    private Integer yearRevenue;
    /**
     * 经度
     */
    private Double longitude;
    /**
     * 纬度
     */
    private Double latitude;
    /**
     * 年龄范围 最小值
     */
    private Integer ageRangeMin;
    /**
     * 年龄范围 最大值
     */
    private Integer ageRangeMax;
    /**
     * 身高范围 最小值
     */
    private Integer heightRangeMin;
    /**
     * 身高范围 最大值
     */
    private Integer heightRangeMax;
    /**
     * 学历 按位或运算 1不限、2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private List<Integer> eduRange;
    /**
     * 年收入 按位或运算 1无所谓、2、五万以下，4、5-10万，8、10-20万，16、20-30万，32、30-40万，64、40-50万，128、50-100万，256、100万以上
     */
    private List<Integer> yearRevenueRange;

    /**
     * 信息完成状态 1=昵称头像 2=1+生活照>=2   3=2+基础信息六项  4=3+实名认证+婚姻认证 5=4+理想伴侣完成100%
     */
    private Integer infoCompleteStatus;

    /**
     * 心动的用户列表
     * @since 2025-07-07
     */
    private List<Long> likeUserList;

    /**
     * 不喜欢的用户列表
     * @since 2025-07-07
     */
    private List<Long> dislikeUserList;

    /**
     * 主动邀约对方见面的用户列表
     * @since 2025-07-07
     */
    private List<Long> inviteUserList;

    public int getAge() {
        return birthday.until(LocalDate.now()).getYears();
    }

    /**
     * @return 获取现居地所属城市（行政区划代码）
     */
    public String getCityCode() {
        if (null == currentPlaceDistrict) {
            return null;
        }
        return StringUtils.rightPad(StringUtils.substring(currentPlaceDistrict.toString(), 0, 4), 6, '0');
    }
}
