package com.bxm.lovelink.rs.facade;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * 用户文档，用于 Elasticsearch 映射
 *
 * @author Allen Hu
 * @date 2025/6/23
 */
@Data
@Accessors(chain = true)
@Document(indexName = UserDocument.INDEX_NAME)
public class UserDocument {

    public static final String INDEX_NAME = "user";

    @Id
    private Long userId;

    private Integer gender;

    private String birthday;
    private Integer zodiac;
    private Integer constellation;
    private Integer height;
    private String currentPlaceDistrict;
    private String nativePlaceDistrict;
    private Integer eduHighest;
    private String industry;
    private String job;
    private Integer yearRevenue;
    private Integer marriage;
    private Integer children;
    private String nickname;
    private Integer loveGoal;
    private Integer house;
    private Integer houseCity;
    private Integer car;

    private Double longitude;
    private Double latitude;
    private Integer lastLoginDistrict;

    private Integer infoCertProgress;
    private Integer infoCompleteProgress;

    private String vipExpireTime;

    private String wechatNumber;
    private Integer certStatus;
    private Integer bodyShape;

    /**
     * 信息完成状态 4除了理想伴侣没完成 5都完成
     */
    private Integer infoCompleteStatus;

    private Integer deleted;

    private String createTime;

    private String modifyTime;

    // -------- 理想伴侣信息 -------- //

    /**
     * 年龄范围 最小值
     */
    private Integer ageRangeMin;

    /**
     * 年龄范围 最大值
     */
    private Integer ageRangeMax;

    /**
     * 身高范围 最小值
     */
    private Integer heightRangeMin;

    /**
     * 身高范围 最大值
     */
    private Integer heightRangeMax;

    /**
     * 学历范围
     */
    private Integer eduRange;

    /**
     * 收入范围
     */
    private Integer yearRevenueRange;

    /**
     * CQS得分
     */
    private Double cqsScore;

    /**
     * 可见性状态。1 正常
     */
    private Integer visibilityStatus;

    /**
     * 用户状态。1 正常
     */
    private Integer status;

    /**
     * 新用户 1是 0 否
     */
    private Integer newUser;
    /**
     * 在线状态 1在线 0离线
     */
    private Integer onlineStatus;

    /**
     * 用户编号
     */
    private String userNumber;

    public int getAge() {
        LocalDate birthday = LocalDate.parse(this.birthday, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return birthday.until(LocalDate.now()).getYears();
    }

}