package com.bxm.mccms.facade.enums;

/**
 * <p>
 * 收款状态 枚举
 * 1未结算，2已结算，3已开票，4已收款
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-7-29
 */
public enum ReceiptStatusEnum {

    UNSETTLED(1, "未结算"),
    SETTLED(2, "已结算"),
    INVOICED(3, "已开票"),
    COLLECTED(4, "已收款"),
    ;

    private int value;
    private String name;

    ReceiptStatusEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static ReceiptStatusEnum get(int value) {
        for (ReceiptStatusEnum temp : ReceiptStatusEnum.values()) {
            if (temp.value == value) {
                return temp;
            }
        }
        return null;
    }

}
