package com.bxm.mccms.facade.enums;

/**
 * <p>
 * 任务状态 枚举
 * 1 正常、2 暂停、3 停止、
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-3-25
 */
public enum TaskStatusEnum {

    RUNING(1, "正常"),
    PAUSE(2, "暂停"),
    STOP(3, "停止"),
    ;

    private int value;
    private String name;

    TaskStatusEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static TaskStatusEnum get(int value) {
        for (TaskStatusEnum temp : TaskStatusEnum.values()) {
            if (temp.value == value) {
                return temp;
            }
        }
        return null;
    }

}
