package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;
import java.math.BigDecimal;

import lombok.Data;

/**
 * 推送模型-流量分发<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/27 13:47
 */
@Data
public class DispatcherDspCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 分发ID
     */
    private Long id;
    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 配置ID
     */
    private Long configId;

    /**
     * 频次控制
     */
    private Integer frequency;

    /**
     * DSP ID
     */
    private Long dspId;
    /**
     * DSP广告位ID
     */
    private String dspPosid;
    /**
     * DSP应用ID
     */
    private String dspAppid;
    /**
     * 优先级,1~5升序
     */
    private int priority;
    /**
     * 放量底价
     */
    private BigDecimal dspBasePrice;
    /**
     * 流量开关,1:开,0:关
     * @see com.bxm.mccms.facade.constant.Constants.Opened
     */
    private byte opened;
}
