package com.bxm.mccms.facade.enums;

/**
 * 创意审核<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/30 10:17
 */
public class DspCreativeEnum {

    /**
     * 审核状态
     */
    public static enum AuditStatus {

        /** 待审核 */
        WAIT(0,"待审核"),
        /** 机审通过 */
        ROBOT_PASS(1,"机审通过"),
        /** 机审不通过 */
        ROBOT_REFUSE(2,"机审不通过"),
        /** 通过 */
        PASS(3,"通过"),
        /** 不通过 */
        REFUSE(4,"不通过"),
        ;
        
        /**
         * 值
         */
        private int id;
        /**
         * 描述
         */
        private String desc;

        AuditStatus(int id, String desc) {
            this.id = id;
            this.desc = desc;
        }

        public int getId() {
            return id;
        }

        public String getDesc() {
            return desc;
        }
    }
}
