package com.bxm.mccms.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bxm.mccms.facade.constant.Constants;
import com.bxm.mccms.facade.model.pushable.GameTemplateCacheVO;

/**
 * <p>
 * 游戏模板 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2022-3-2
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface IGameTemplateFacadeService {

    /**
     * 推送
     * @param dto
     * @return
     */
    @RequestMapping(value = "/facade/gameTemplate/push", method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> push(@RequestBody GameTemplateCacheVO dto);

}
