package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 广告位集合。</br>
 * Created by zhengwangeng on 2021/9/27 11:29.
 */
@Data
public class PositionCollectionCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告位Id
     */
    private String positionId;

    /**
     * 广告位场景
     */
    private Integer positionScene;

    /**
     * 平台类型：1 IOS，2 安卓，3 H5，4 PC
     */
    private Integer platformType;

    /**
     * 行数
     */
    private Integer row;

    /**
     * 总数
     */
    private Integer total;

    /**
     * 子广告位
     */
    private List<ChildPosition> childPositions;

    @Data
    public static class ChildPosition implements Serializable {

        private static final long serialVersionUID = 1L;

        /**
         * 子广告位Id
         */
        private String childPositionId;

        /**
         * 排序
         */
        private Integer sort;

    }



}

