package com.bxm.mccms.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.mccms.facade.constant.Constants;

/**
 * <p>
 * 应用游戏模板 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-12-24
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface IAppGameTemplateFacadeService {

    /**
     * 修改 应用游戏模板 状态
     * @param code
     * @param status 1.开, 0.关
     * @return
     */
    @RequestMapping(value = "/facade/appGameTemplate/updateStatus", method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> updateStatus(@RequestParam(value = "code", required = true) String code,
                                         @RequestParam(value = "status", required = true) Integer status);
}
