package com.bxm.mccms.facade.constant.pushable;

/**
 * 消息推送服务名<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/26 16:26
 */
public enum CachePushableServiceEnum {

	/** 全局配置 */
	CONFIG("CONFIG","CONFIG"),

	/** 开发者应用 */
	APP("APP","开发者应用"),
	/** 广告位 */
	POSITION("POSITION","广告位"),
	/** 创意 */
	CREATIVE("CREATIVE","创意"),
	/** 流量分发 */
	DISPATCHER("DISPATCHER","流量分发"),
	/** 流量分发-AB */
	DISPATCHERAB("DISPATCHERAB","流量分发"),
	/** DSP */
	DSP("DSP","DSP"),
	ADVERT_POINT("ADVERT_POINT","广告位端点数据"),
	DATA_LOG("DATA_LOG","抓取日志请求数据"),
	/** 广告位SDK配置 */
	POSITION_SDK_CONFIG("POSITION_SDK_CONFIG","广告位SDK配置"),
	/* 广告位SDK轮次配置 */
	POSITION_SDK_ROUNDS("POSITION_SDK_ROUNDS","广告位SDK轮次配置"),
	/** 广告位屏蔽策略 */
	SHIELD_STRATEGY("SHIELD_STRATEGY","广告位屏蔽策略"),
	/** 广告位组件 */
	POSITION_ASSEMBLY("POSITION_ASSEMBLY","广告位组件"),
	/** 任务 */
	TASK("TASK","任务"),
	/** 广告位场景DSP设置 */
	SCENE_SETTING_CONFIG("SCENE_SETTING_CONFIG","广告位场景DSP设置"),
	/** 广告位与互动广告入口的映射关系配置 */
	POSITION_INTERACT_APPENTRANCE_REF("POSITION_INTERACT_APPENTRANCE_REF","广告位与互动广告入口的映射关系配置"),
	/** 广告位集合 */
	POSITION_COLLECTION("POSITION_COLLECTION","广告位集合"),
	/** 应用游戏模板 */
	APP_GAME_TEMPLATE("APP_GAME_TEMPLATE","应用游戏模板"),
	/** 游戏模板 */
	GAME_TEMPLATE("GAME_TEMPLATE","游戏模板"),
	/** 广告位流量分配优化 */
	POSITION_DSP_OPTIMIZATION("POSITION_DSP_OPTIMIZATION","广告位流量分配优化"),
	/** adx替换素材 */
	ADX_REPLACE_CREATIVE("ADX_REPLACE_CREATIVE","adx替换素材"),
	/** 预审创意 */
	CREATIVE_REVIEW("CREATIVE_REVIEW","预审创意"),
	;

	/**
	 * 服务名
	 */
	private String name;
	/**
     * 描述
	 */
	private String desc;

	CachePushableServiceEnum(String name, String desc) {
		this.name = name;
		this.desc = desc;
	}

	public String getName() {
		return name;
	}

	public String getDesc() {
		return desc;
	}
}
