package com.bxm.mccms.facade.model.pushable;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author jingyu.li
 * @date 2023-09-05
 */
@Data
public class CreativeReviewCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 素材名
     */
    private String name;

    /**
     * 创意标题
     */
    private String title;

    /**
     * 描述
     */
    private String content;

    /**
     * 创意类型:TEXT_ICON—图文混合广告，VIDEO—视频广告
     */
    private String type;

    /**
     * 目标投放平台:ANDROID：安卓,IOS：ios, GENERAL：通投, OTHER_PLATFORM：其他平台
     */
    private String targetPlatform;

    /**
     * 应用icon url creativeType = STICKER时 必填 要求比例1:1, 大于156像素, 图片小于100K(含)
     */
    private String iconUrl;

    /**
     * 应用icon
     */
    private Integer iconHeight;

    /**
     * 应用icon
     */
    private Integer iconWeight;

    /**
     * 图片地址 creativeType是TEXT_ICON时必填
     */
    private String imgUrl;

    /**
     * 图片高度
     */
    private Integer imgHeight;

    /**
     * 图片宽度
     */
    private Integer imgWeight;

    /**
     * 封面图地址
     */
    private String coverUrl;

    /**
     * 视频链接 creativeType是VIDEO/VERTICAL_SCREEN/HORIZONTAL_SCREEN时必填
     */
    private String videoUrl;

    /**
     * 视频高度
     */
    private Integer videoHeight;

    /**
     * 视频宽度
     */
    private Integer videoWeight;

    /**
     * 视频时间长度
     */
    private Integer videoDuration;

    /**
     * clickUrl
     */
    private String clickUrl;

    /**
     * depLinkUrl
     */
    private String deepLinkUrl;

    private String appName;

    private String packageName;

    private Integer packageSize;

    /**
     * NO_INTERACTION—无动作，SURFING—使用浏览器打开网页，DOWNLOAD—下载应用
     */
    private String interactionType;

    /**
     * 审核媒体返回的创意ID
     */
    private String mediaCreativeId;

    /**
     * 平台ID
     */
    private Long dspId;

    /**
     * 审核状态0：未提审1：提审中2：拒绝3：审核通过
     */
    private Integer status;

    /**
     * 删除标识0：未删除1：已删除
     */
    private Integer deleted;

    /**
     * 提审媒体
     */
    private String media;

    /**
     * 审核状态描述
     */
    private String msg;

    private String ext;

    private Date createTime;

    private String createUser;

    private Date modifyTime;

    private String modifyUser;
}
