package com.bxm.mccms.facade.model.pushable;

import com.bxm.mccms.facade.model.Rule;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 推送模型-流量分发<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/27 13:47
 */
@Data
public class DispatcherDspCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 分发ID
     */
    private Long id;
    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 策略id
     */
    private Long strategyId;

    /**
     * 配置ID
     */
    private Long configId;

    /**
     * 频次控制
     */
    private Integer frequency;

    /**
     * DSP ID
     */
    private Long dspId;

    /**
     * DSP广告位ID
     */
    private String dspPosid;

    /**
     * DSP应用ID
     */
    private String dspAppid;

    /**
     * 分发优先级,1~5升序
     */
    private int priority;

    /**
     * 返回优先级,1~5升序
     */
    private Integer returnPriority;

    /**
     * 平均cpm类型 0：固价 1：不设置 2：固价+打折
     */
    private Integer avgType;

    /**
     * 平均CPM价
     */
    private BigDecimal dspAvgPrice;

    /**
     * 放量底价CPM
     */
    private BigDecimal dspBasePrice;

    /**
     * 应用包名
     */
    private String appPackageName;

    /**
     * 利润率
     */
    private BigDecimal profitMargin;

    /**
     * 曝光上限
     */
    private Integer maxExposure;

    /**
     * 面向下游（流量方）的出价类型
     * @see com.bxm.mccms.facade.enums.OfferSettle
     */
    private String mediaSettle;

    /**
     * 流量开关,1:开,0:关
     * @see com.bxm.mccms.facade.constant.Constants.Opened
     */
    private byte opened;


    /**
     * 已安装APP定向
     */
    private Rule installedAppDirect;

    /**
     * 媒体APP定向
     */
    private Rule mediaAppDirect;

    /**
     * 媒体ID定向
     */
    private Rule mediaIdDirect;

    /**
     * 关联的素材列表
     */
    private List<Long> creativeIdList;

    /**
     * 关联的预审创意
     */
    private List<String> creativeReviewIdList;

    /**
     * dsp出价配置明细
     */
    private List<DispatcherDspPosPriceConfigVO> dispatcherDspPosPriceConfigVOS;


    /**
     * 人群包定向,多个逗号分隔 示例："1,2&3" 1,2是白，3是黑
     */
    private Rule crowdPackageOrientation;

    /**setDispatcherDspPosPriceConfigVOS
     * 区域定向 示例："1-1,2,3" 或 "2-4,5,6"
     */
    private Rule citys;

    /**
     * 频次控制定向 示例：
     * 请求（1）-时间-时间单位（1：小时2：天）-频次,竟参（2）-时间-时间单位（1：小时2：天）-频次,曝光（3）-时间-时间单位（1：小时2：天）-频次,点击（4）-时间-时间单位（1：小时2：天）-频次
     * 1-1-1-1,2-2-1-2,3-3-1-3,4-4-1-4
     */
    private Rule frequencys;

    /**
     * 设备信息定向 示例： imei|oaid|idfa,CAID,boot_mark,update_mark
     */
    private Rule deviceInfo;

    /**
     * 探针 示例 0.01 = 1%
     */
    private BigDecimal probe;

    /**
     * 砍量开关0：关闭，1：开启
     */
    private Integer chopQuantitySwitch;

    /**
     * 底价系数
     */
    private BigDecimal basePriceCoefficient;


    /**
     * cpc管控
     */
    private Integer cpcControl;

    /**
     * cpc上限
     */
    private BigDecimal cpcUpperLimit;

    /**
     * cpc利润率下限
     */
    private BigDecimal profitMarginBottom;

    /**
     *工程计算的出价系数
     */
    private BigDecimal projectBiddingCoefficient;

    /**
     *工程计算的折扣
     */
    private BigDecimal projectDiscount;

    /**
     * 工程计算时间
     */
    private Date projectTime;

}
