package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;
import java.math.BigDecimal;

import lombok.Data;

/**
 * <p>
 * 推送模型-广告位SDK轮次配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-08-25
 */
@Data
public class PositionSdkRoundsConfigCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 轮次ID
     */
    private Long sdkRoundsId;

    /**
     * 广告位Id
     */
    private String positionId;

    /**
     * 渠道类型
     */
    private String channelType;

    /**
     * 渠道应用id
     */
    private String channelApplicationId;

    /**
     * 渠道广告位Id
     */
    private String channelPositionId;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 开关状态：1.开, 0.关
     */
    private Integer status;

    /**
     * 平均CPM,单位为元
     */
    private BigDecimal avgCpm;

    /**
     * CPM范围最小值,单位为元
     */
    private BigDecimal minCpm;

    /**
     * CPM范围最大值,单位为元
     */
    private BigDecimal maxCpm;

}
