package com.bxm.mccms.facade.enums;

/**
 * 广告位场景DSP <br/>
 *
 * @author zhengwangeng
 * @since 2020-8-13
 */
public class SceneDspEnum {

    /**
     * 场景类型
     */
    public enum SceneType {

        /** 互动激励视频 */
        SCENE_TYPE_INSPIRE_VIDEO(1, "互动激励视频"),

        /** 变现百宝箱 */
        SCENE_TYPE_BBX(2, "变现百宝箱"),

        /** 互动广告 */
        SCENE_TYPE_INTERACT(3, "互动广告"),

        /** SDK复合活动 */
        SCENE_TYPE_SDK_COMPOUND_ACTIVITY(4, "SDK复合活动"),
        ;

        /**
         * 值
         */
        private int type;

        /**
         * 描述
         */
        private String desc;

        SceneType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public static SceneType get(int type) {
            for (SceneType temp : SceneType.values()) {
                if (temp.type == type) {
                    return temp;
                }
            }
            return null;
        }
    }

    /**
     * 素材来源：1是为手动上传，2为素材库素材
     */
    public enum CreativeSource {

        /** 手动上传 */
        MANUAL(1, "手动上传"),

        /** 素材库素材 */
        CREATIVE(2, "素材库素材"),
        ;

        /**
         * 值
         */
        private int type;

        /**
         * 描述
         */
        private String desc;

        CreativeSource(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public static CreativeSource get(int type) {
            for (CreativeSource temp : CreativeSource.values()) {
                if (temp.type == type) {
                    return temp;
                }
            }
            return null;
        }
    }

    /**
     * 筛选类型：1标签筛选，2个性筛选
     */
    public enum ScreenType {

        /** 标签筛选 */
        TAG_SCREEN(1, "标签筛选"),

        /** 个性筛选 */
        PERSONALITY_SCREEN(2, "个性筛选"),
        ;

        /**
         * 值
         */
        private int type;

        /**
         * 描述
         */
        private String desc;

        ScreenType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public static ScreenType get(int type) {
            for (ScreenType temp : ScreenType.values()) {
                if (temp.type == type) {
                    return temp;
                }
            }
            return null;
        }
    }
}
