package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;

import lombok.Data;

/**
 * 推送模型-开发者应用<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/27 13:47
 */
@Data
public class AppCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;
    /**
     * AppID
     */
    private String appId;
    /**
     * 应用包名
     */
    private String appPackageName;
    /**
     * 审核状态：0 风控终审，1 终审通过，2 终审拒绝，3 媒介初审，4 初审拒绝
     */
    private Integer status;
    /**
     * 是否逻辑删除：1 表示删除，0 表示未删除
     */
    private Integer deleted;
    /**
     * 是否开启耍呗：1-开启，0-关闭
     */
    private Integer flourished;

    /**
     * 应用下【推送】场景的广告位positionId
     */
    private String pushScenePositionId;

    /**
     * 应用下【锁屏】场景的广告位positionId
     */
    private String lockScreenScenePositionId;
}
