package com.bxm.mccms.facade.service.adx;

import com.bxm.mccms.facade.constant.Constants;
import com.bxm.mccms.facade.model.adx.CreativeFacadeDTO;
import com.bxm.mccms.facade.model.adx.CreativeFacadeVO;
import com.bxm.mccms.facade.model.adx.CreativeQueryFacadeDTO;
import com.bxm.mccms.facade.model.adx.CreativeReviewFacadeVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * Created by Arei on 2019/12/20.
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface CreativeService {
    @PostMapping("/creativeService/creatives/add")
    List<String> addCreative(@RequestBody List<CreativeFacadeDTO> creativeFacadeDTOS);

    @PostMapping("/creativeService/creatives/modify")
    List<String> modifyCreative(@RequestBody List<CreativeFacadeDTO> creativeFacadeDTOs);

    @PostMapping("/creativeService/creatives/query")
    List<CreativeFacadeVO> queryCreativeByIds(@RequestBody CreativeQueryFacadeDTO creativeQueryFacadeDTO);

    @PostMapping("/creativeService/creatives/query/reviewStatus")
    List<CreativeReviewFacadeVO> queryReviewStatus(@RequestBody CreativeQueryFacadeDTO creativeQueryFacadeDTO);
}
