package com.bxm.mccms.facade.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author jingyu.li
 * @date 2023-09-05
 */
public interface CreativeReviewEnum {

    @AllArgsConstructor
    @Getter
    enum Status {
        unaudited(0, "未审核"),
        underReview(1, "审核中"),
        refusalToReview(2, "拒审"),
        approved(3, "审核通过"),
        ;

        private Integer code;

        private String desc;
    }

    @AllArgsConstructor
    @Getter
    enum Type {
        TEXT_ICON("TEXT_ICON", "图文混合"),
        VIDEO("VIDEO", "视频"),
        VERTICAL_SCREEN("VERTICAL_SCREEN", "竖版视频"),
        HORIZONTAL_SCREEN("HORIZONTAL_SCREEN", "横版视频"),
        ;

        private String code;

        private String desc;

        public static String getByName(String name) {
            for (Type value : Type.values()) {
                if (value.getDesc().equals(name)) {
                    return value.getCode();
                }
            }
            return null;
        }
    }

    @AllArgsConstructor
    @Getter
    enum TargetPlatform {
        ANDROID("ANDROID", "安卓"),
        IOS("IOS", "IOS"),
        GENERAL("GENERAL", "通投"),
        OTHER_PLATFORM("OTHER_PLATFORM", "其他平台"),
        ;

        private String code;

        private String desc;

        public static String getByName(String name) {
            for (TargetPlatform value : TargetPlatform.values()) {
                if (value.getDesc().equals(name)) {
                    return value.getCode();
                }
            }
            return null;
        }
    }

    @AllArgsConstructor
    @Getter
    enum Media {
        kuaishou("kuaishou", "快手"),
        kuaishoujuwang("kuaishoujuwang", "快手-巨网"),
        ezvizCloud("ezvizcloud", "萤石云"),
        netease("netease", "网易"),
        meitu("meitu", "美图"),
        uc("uc", "UC汇川"),
        ;
        private String code;
        private String desc;

        public static String getCodeByName(String name) {
            for (Media value : Media.values()) {
                if (value.getDesc().equals(name)) {
                    return value.getCode();
                }
            }
            return null;
        }
    }



    @AllArgsConstructor
    @Getter
    enum InteractionType {
        NO_INTERACTION("NO_INTERACTION", "0—无动作，即广告广告点击后无需进行任何响应—暂不支持"),
        SURFING("SURFING", "1—使用浏览器打开网页"),
        DOWNLOAD("DOWNLOAD", "2—下载应用"),
        ;

        private String code;

        private String desc;

    }

    @AllArgsConstructor
    @Getter
    enum AdType {
        DEFAULT("KUAISHOU_EXPLORE_FEED_VIDEO", "默认"),
        SLOT_VIDEO("KUAISHOU_SPLASH_SLOT_VIDEO", "开屏视频"),
        SLOT_PIC("KUAISHOU_SPLASH_SLOT_PIC_TEXT", "开屏图片"),
        ;

        private String code;

        private String desc;
    }
}
