package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 推送模型-广告位SDK轮次<br/>
 *
 * @author zhengwangeng
 * @since 2021-08-25
 */
@Data
public class PositionSdkRoundsCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 广告位Id
     */
    private String positionId;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 超时时间，单位是ms
     */
    private Integer timeout;

    /**
     * 最大等待时间，单位是ms
     */
    private Integer maxWaitTime;

    /**
     * 开关状态：1.开, 0.关
     */
    private Integer status;

    private List<PositionSdkRoundsConfigCacheVO> roundsConfigList;

}
