package com.bxm.mcssp.common.util;

import org.apache.commons.codec.digest.DigestUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.*;
import java.util.Map.Entry;

/**
 * 类MD5Util.java的实现描述：MD5工具类
 *
 * @author leon 2016年9月16日 下午5:21:45
 */
public class MD5Util {

    // URL有效期：5分钟
    private static final long URL_EFFECTIVE_TIME = 5 * 1000 * 60;

    /**
     * 方法描述:将字符串MD5加码 生成32位md5码
     *
     * @param inStr
     * @return
     * @author leon 2016年10月10日 下午3:02:30
     */
    public static String md5(String inStr) {
        try {
            return DigestUtils.md5Hex(inStr.getBytes("UTF-8"));
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5签名过程中出现错误");
        }
    }

    /**
     * 方法描述:验证url有效期
     *
     * @param timestamp
     * @throws Exception
     * @author leon 2016年10月26日 下午2:50:08
     */
    public static void validateURLEffective(long timestamp) throws Exception {
        long now = System.currentTimeMillis();
        if ((now - timestamp) > (URL_EFFECTIVE_TIME)) {
            // System.out.println("URL链接失效 URL link failure");
            throw new Exception(URLEncoder.encode("URL链接失效", "UTF-8"));
        }
    }

    /**
     * 方法描述:签名字符串
     *
     * @param params    需要签名的参数
     * @param appSecret 签名密钥
     * @return
     * @author leon 2016年10月10日 下午2:54:47
     */
    public static String sign(HashMap<String, String> params, String appSecret) {
        StringBuilder valueSb = new StringBuilder();
        params.put("appSecret", appSecret);
        // 将参数以参数名的字典升序排序
        Map<String, String> sortParams = new TreeMap<String, String>(params);
        Set<Entry<String, String>> entrys = sortParams.entrySet();
        // 遍历排序的字典,并拼接value1+value2......格式
        for (Entry<String, String> entry : entrys) {
            valueSb.append(entry.getValue());
            // System.out.println("params sort :" + entry.getKey() + "-------->" + entry.getValue());
        }
        // 此处删除appSecret，因为appSecret不能出现在url上,否则生成MD5签名无法验证
        params.remove("appSecret");
        return md5(valueSb.toString());
    }

    /**
     * 方法描述:验证签名
     *
     * @param appSecret 加密秘钥
     * @param request
     * @return
     * @throws Exception
     * @author leon 2016年10月10日 下午2:31:23
     */
    public static boolean verify(String appSecret, HttpServletRequest request) throws Exception {

        String sign = request.getParameter("sign");
        if (sign == null) {
            throw new Exception(URLEncoder.encode("请求中没有带签名", "UTF-8"));
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception(URLEncoder.encode("请求中没有带时间戳", "UTF-8"));
        }
        // 验证url有效期
        validateURLEffective(Long.valueOf(request.getParameter("timestamp")));

        HashMap<String, String> params = new HashMap<String, String>();

        // 获取url参数
        Enumeration<String> enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paramName = enu.nextElement().trim();
            if (!paramName.equals("sign")) {
                // 拼接参数值字符串并进行utf-8解码，防止中文乱码产生
                params.put(paramName, URLDecoder.decode(request.getParameter(paramName), "UTF-8"));
            }
        }

        params.put("appSecret", appSecret);

        // 将参数以参数名的字典升序排序
        Map<String, String> sortParams = new TreeMap<String, String>(params);
        Set<Entry<String, String>> entrys = sortParams.entrySet();

        // 遍历排序的字典,并拼接value1+value2......格式
        StringBuilder valueSb = new StringBuilder();
        for (Entry<String, String> entry : entrys) {
            valueSb.append(entry.getValue());
            // System.out.println("params sort :" + entry.getKey() + "-------->" + entry.getValue());
        }

        String mysign = md5(valueSb.toString());
        // System.out.println("mysign-------------------------->" + mysign);
        // System.out.println("sign-------------------------->" + sign);
        if (mysign.equals(sign)) {
            return true;
        } else {
            return false;
        }

    }

}
