package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 广告样式、模板
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-3-11
 */
public enum PositionAdStyleTypeEnum {

    /**
     * 不限
     * 动画650*650，浮标120*120
     */
    NONE(PositionSceneTypeEnum.ANIMATION_ICON, 18001, "不限"),

    /**
     * 纵向动画浮标
     * 动画120*650，浮标120*120
     */
    W_ICON(PositionSceneTypeEnum.ANIMATION_ICON, 18002, "纵向动画浮标"),

    /**
     * 横向动画浮标
     * 动画450*120，浮标120*120
     */
    H_ICON(PositionSceneTypeEnum.ANIMATION_ICON, 18003, "横向动画浮标");

    private PositionSceneTypeEnum positionSceneTypeEnum;

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public PositionSceneTypeEnum getPositionSceneTypeEnum() {
        return positionSceneTypeEnum;
    }

    PositionAdStyleTypeEnum(PositionSceneTypeEnum positionSceneTypeEnum, Integer type, String desc) {
        this.positionSceneTypeEnum = positionSceneTypeEnum;
        this.type = type;
        this.desc = desc;
    }

    public static PositionAdStyleTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionAdStyleTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }
}
