package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 广告样式、模板
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-3-11
 */
public enum PositionAdStyleTypeEnum {

    /**
     * 不限
     * 动画650*650，浮标120*120
     */
    NONE(PositionSceneTypeEnum.ANIMATION_ICON, 18001, "不限",1, 1),

    /**
     * 纵向动画浮标
     * 动画120*650，浮标120*120
     */
    W_ICON(PositionSceneTypeEnum.ANIMATION_ICON, 18002, "纵向动画浮标",1, 1),

    /**
     * 横向动画浮标
     * 动画450*120，浮标120*120
     */
    H_ICON(PositionSceneTypeEnum.ANIMATION_ICON, 18003, "横向动画浮标",1, 1),


    //聚合图文
    /**
     * 单行4个
     */
    COLLECTION_VIDEOTEX_SINGLE_LINE_FOUR(PositionSceneTypeEnum.COLLECTION_VIDEOTEX, 18101, "单行4个",4, 1),
    /**
     * 单行5个
     */
    COLLECTION_VIDEOTEX_SINGLE_LINE_FIVE(PositionSceneTypeEnum.COLLECTION_VIDEOTEX, 18102, "单行5个",5, 1),
    /**
     * 双行8个
     */
    COLLECTION_VIDEOTEX_DOUBLE_LINE_EIGHT(PositionSceneTypeEnum.COLLECTION_VIDEOTEX, 18103, "双行8个",8, 2),
    /**
     * 双行10个
     */
    COLLECTION_VIDEOTEX_DOUBLE_LINE_TEN(PositionSceneTypeEnum.COLLECTION_VIDEOTEX, 18104, "双行10个",10, 2),



    //聚合非标Banner
    /**
     * 单行2个
     */
    COLLECTION_NON_STANDARD_BANNER_SINGLE_LINE_TWO(PositionSceneTypeEnum.COLLECTION_NON_STANDARD_BANNER, 18201, "单行2个",2, 1),
    /**
     * 单行3个
     */
    COLLECTION_NON_STANDARD_SINGLE_LINE_THREE(PositionSceneTypeEnum.COLLECTION_NON_STANDARD_BANNER, 18202, "单行3个",3, 1),
    /**
     * 双行4个
     */
    COLLECTION_NON_STANDARD_DOUBLE_LINE_FOUR(PositionSceneTypeEnum.COLLECTION_NON_STANDARD_BANNER, 18203, "双行4个", 4, 2),
    /**
     * 双行6个
     */
    COLLECTION_NON_STANDARD_DOUBLE_LINE_SIX(PositionSceneTypeEnum.COLLECTION_NON_STANDARD_BANNER, 18204, "双行6个", 6, 2),
    ;


    private PositionSceneTypeEnum positionSceneTypeEnum;

    private Integer type;

    private String desc;

    /**
     * 总个数
     */
    private Integer total;
    /**
     * 行数
     */
    private Integer row;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getTotal() {
        return total;
    }

    public Integer getRow() {
        return row;
    }

    public PositionSceneTypeEnum getPositionSceneTypeEnum() {
        return positionSceneTypeEnum;
    }

    PositionAdStyleTypeEnum(PositionSceneTypeEnum positionSceneTypeEnum, Integer type, String desc, Integer total, Integer row) {
        this.positionSceneTypeEnum = positionSceneTypeEnum;
        this.type = type;
        this.desc = desc;
        this.total = total;
        this.row = row;
    }

    public static PositionAdStyleTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionAdStyleTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }
}
