/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mcssp.common.enums.position;

import com.bxm.mcssp.common.enums.position.CustomPositionTypeEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum PositionSceneTypeEnum {
    INFORMATION_FLOW(1, "\u4fe1\u606f\u6d41", CustomPositionTypeEnum.STANDARD),
    BOOT(2, "\u5f00\u5c4f", CustomPositionTypeEnum.STANDARD),
    BANNER(3, "banner", CustomPositionTypeEnum.STANDARD),
    SCREEN(4, "\u63d2\u5c4f", CustomPositionTypeEnum.STANDARD),
    ICON(5, "\u6d6e\u6807", CustomPositionTypeEnum.NON_STANDARD),
    BUTTON(6, "\u975e\u6807banner", CustomPositionTypeEnum.NON_STANDARD),
    SEARCH(7, "\u641c\u7d22", CustomPositionTypeEnum.OTHER),
    INSPIRE_VIDEO(8, "\u6fc0\u52b1\u89c6\u9891", CustomPositionTypeEnum.STANDARD),
    VIDEO(9, "\u5168\u5c4f\u89c6\u9891", CustomPositionTypeEnum.STANDARD),
    INFORMATION_FLOW_SELF_RENDERING(11, "\u81ea\u6e32\u67d3\u4fe1\u606f\u6d41", CustomPositionTypeEnum.OTHER),
    SPECIAL_POSITION(12, "\u7279\u6b8a\u5e7f\u544a\u4f4d", CustomPositionTypeEnum.OTHER),
    SELF_RENDERING(13, "\u81ea\u6e32\u67d3", CustomPositionTypeEnum.NON_STANDARD),
    INFORMATION_FLOW_IMMERSIVE_VIDEO(14, "\u6c89\u6d78\u5f0f\u4fe1\u606f\u6d41\u89c6\u9891", CustomPositionTypeEnum.STANDARD),
    PUSH(15, "\u63a8\u9001", CustomPositionTypeEnum.NON_STANDARD),
    TAB_PAGE(16, "Tab\u9875", CustomPositionTypeEnum.NON_STANDARD),
    LOCK_SCREEN(17, "\u9501\u5c4f", CustomPositionTypeEnum.NON_STANDARD),
    ANIMATION_ICON(18, "\u52a8\u753b\u6d6e\u6807", CustomPositionTypeEnum.NON_STANDARD),
    VIDEOTEX(19, "\u56fe\u6587", CustomPositionTypeEnum.NON_STANDARD),
    COLLECTION_VIDEOTEX(20, "\u805a\u5408\u56fe\u6587", CustomPositionTypeEnum.COLLECTION),
    COLLECTION_NON_STANDARD_BANNER(21, "\u805a\u5408\u975e\u6807Banner", CustomPositionTypeEnum.COLLECTION),
    TEXT_LINK(22, "\u6587\u5b57\u94fe", CustomPositionTypeEnum.NON_STANDARD);

    private Integer type;
    private String desc;
    private CustomPositionTypeEnum customPositionTypeEnum;

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public CustomPositionTypeEnum getCustomPositionTypeEnum() {
        return this.customPositionTypeEnum;
    }

    private PositionSceneTypeEnum(Integer type, String desc, CustomPositionTypeEnum customPositionTypeEnum) {
        this.type = type;
        this.desc = desc;
        this.customPositionTypeEnum = customPositionTypeEnum;
    }

    public static PositionSceneTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionSceneTypeEnum anEnum : PositionSceneTypeEnum.values()) {
            if (!anEnum.getType().equals(type)) continue;
            return anEnum;
        }
        return null;
    }

    public static List<Integer> getTypeListByCustomPositionTypeEnum(CustomPositionTypeEnum customPositionTypeEnum) {
        if (null == customPositionTypeEnum) {
            return Collections.emptyList();
        }
        PositionSceneTypeEnum[] values = PositionSceneTypeEnum.values();
        ArrayList<Integer> positionTypes = new ArrayList<Integer>(values.length);
        for (PositionSceneTypeEnum positionSceneTypeEnum : values) {
            if (customPositionTypeEnum != positionSceneTypeEnum.getCustomPositionTypeEnum()) continue;
            positionTypes.add(positionSceneTypeEnum.getType());
        }
        return positionTypes;
    }

    public static List<Integer> getStandardPosition() {
        return PositionSceneTypeEnum.getTypeListByCustomPositionTypeEnum(CustomPositionTypeEnum.STANDARD);
    }

    public static List<Integer> getNonStandardPosition() {
        return PositionSceneTypeEnum.getTypeListByCustomPositionTypeEnum(CustomPositionTypeEnum.NON_STANDARD);
    }
}

